/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ha.session;

import java.util.HashSet;
import java.util.Set;
import org.apache.catalina.DistributedManager;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Session;
import org.apache.catalina.ha.ClusterManager;
import org.apache.catalina.ha.ClusterMessage;
import org.apache.catalina.ha.session.ClusterManagerBase;
import org.apache.catalina.ha.session.DeltaSession;
import org.apache.catalina.tribes.tipis.AbstractReplicatedMap;
import org.apache.catalina.tribes.tipis.LazyReplicatedMap;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public class BackupManager
extends ClusterManagerBase
implements AbstractReplicatedMap.MapOwner,
DistributedManager {
    private final Log log = LogFactory.getLog(BackupManager.class);
    protected static final StringManager sm = StringManager.getManager(BackupManager.class);
    protected static final long DEFAULT_REPL_TIMEOUT = 15000L;
    protected String name;
    private int mapSendOptions = 6;
    private long rpcTimeout = 15000L;
    private boolean terminateOnStartFailure = false;
    private long accessTimeout = 5000L;

    @Override
    public void messageDataReceived(ClusterMessage clusterMessage) {
    }

    @Override
    public ClusterMessage requestCompleted(String string) {
        if (!this.getState().isAvailable()) {
            return null;
        }
        LazyReplicatedMap lazyReplicatedMap = (LazyReplicatedMap)this.sessions;
        lazyReplicatedMap.replicate((Object)string, false);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void objectMadePrimary(Object object, Object object2) {
        if (object2 instanceof DeltaSession) {
            DeltaSession deltaSession;
            DeltaSession deltaSession2 = deltaSession = (DeltaSession)object2;
            synchronized (deltaSession2) {
                deltaSession.access();
                deltaSession.setPrimarySession(true);
                deltaSession.endAccess();
            }
        }
    }

    public Session createEmptySession() {
        return new DeltaSession(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    protected void startInternal() throws LifecycleException {
        super.startInternal();
        try {
            if (this.cluster == null) {
                throw new LifecycleException(sm.getString("backupManager.noCluster", new Object[]{this.getName()}));
            }
            LazyReplicatedMap lazyReplicatedMap = new LazyReplicatedMap((AbstractReplicatedMap.MapOwner)this, this.cluster.getChannel(), this.rpcTimeout, this.getMapName(), this.getClassLoaders(), this.terminateOnStartFailure);
            lazyReplicatedMap.setChannelSendOptions(this.mapSendOptions);
            lazyReplicatedMap.setAccessTimeout(this.accessTimeout);
            this.sessions = lazyReplicatedMap;
        }
        catch (Exception exception) {
            this.log.error((Object)sm.getString("backupManager.startUnable", new Object[]{this.getName()}), (Throwable)exception);
            throw new LifecycleException(sm.getString("backupManager.startFailed", new Object[]{this.getName()}), (Throwable)exception);
        }
        this.setState(LifecycleState.STARTING);
    }

    public String getMapName() {
        String string = this.cluster.getManagerName(this.getName(), this) + "-map";
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Backup manager, Setting map name to:" + string));
        }
        return string;
    }

    @Override
    protected void stopInternal() throws LifecycleException {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)sm.getString("backupManager.stopped", new Object[]{this.getName()}));
        }
        this.setState(LifecycleState.STOPPING);
        if (this.sessions instanceof LazyReplicatedMap) {
            LazyReplicatedMap lazyReplicatedMap = (LazyReplicatedMap)this.sessions;
            lazyReplicatedMap.breakdown();
        }
        super.stopInternal();
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    public void setMapSendOptions(int n) {
        this.mapSendOptions = n;
    }

    public int getMapSendOptions() {
        return this.mapSendOptions;
    }

    public void setRpcTimeout(long l) {
        this.rpcTimeout = l;
    }

    public long getRpcTimeout() {
        return this.rpcTimeout;
    }

    public void setTerminateOnStartFailure(boolean bl) {
        this.terminateOnStartFailure = bl;
    }

    public boolean isTerminateOnStartFailure() {
        return this.terminateOnStartFailure;
    }

    public long getAccessTimeout() {
        return this.accessTimeout;
    }

    public void setAccessTimeout(long l) {
        this.accessTimeout = l;
    }

    @Override
    public String[] getInvalidatedSessions() {
        return new String[0];
    }

    @Override
    public ClusterManager cloneFromTemplate() {
        BackupManager backupManager = new BackupManager();
        this.clone(backupManager);
        backupManager.mapSendOptions = this.mapSendOptions;
        backupManager.rpcTimeout = this.rpcTimeout;
        backupManager.terminateOnStartFailure = this.terminateOnStartFailure;
        backupManager.accessTimeout = this.accessTimeout;
        return backupManager;
    }

    public int getActiveSessionsFull() {
        LazyReplicatedMap lazyReplicatedMap = (LazyReplicatedMap)this.sessions;
        return lazyReplicatedMap.sizeFull();
    }

    public Set<String> getSessionIdsFull() {
        LazyReplicatedMap lazyReplicatedMap = (LazyReplicatedMap)this.sessions;
        HashSet<String> hashSet = new HashSet<String>(lazyReplicatedMap.keySetFull());
        return hashSet;
    }
}

