/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.brotli;

import java.io.IOException;
import java.io.InputStream;
import net.sourceforge.plantuml.brotli.BrotliRuntimeException;

final class Utils {
    private static final byte[] BYTE_ZEROES = new byte[1024];
    private static final int[] INT_ZEROES = new int[1024];

    Utils() {
    }

    static void fillBytesWithZeroes(byte[] dest, int start, int end) {
        int step;
        for (int cursor = start; cursor < end; cursor += step) {
            step = Math.min(cursor + 1024, end) - cursor;
            System.arraycopy(BYTE_ZEROES, 0, dest, cursor, step);
        }
    }

    static void fillIntsWithZeroes(int[] dest, int start, int end) {
        int step;
        for (int cursor = start; cursor < end; cursor += step) {
            step = Math.min(cursor + 1024, end) - cursor;
            System.arraycopy(INT_ZEROES, 0, dest, cursor, step);
        }
    }

    static void copyBytesWithin(byte[] bytes, int target, int start, int end) {
        System.arraycopy(bytes, start, bytes, target, end - start);
    }

    static int readInput(InputStream src, byte[] dst, int offset, int length) {
        try {
            return src.read(dst, offset, length);
        }
        catch (IOException e) {
            throw new BrotliRuntimeException("Failed to read input", e);
        }
    }

    static void closeInput(InputStream src) throws IOException {
        src.close();
    }
}

