/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.memory;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.memory.CardGeneration;
import sun.jvm.hotspot.memory.CompactibleFreeListSpace;
import sun.jvm.hotspot.memory.Generation;
import sun.jvm.hotspot.memory.SpaceClosure;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObjectFactory;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public class ConcurrentMarkSweepGeneration
extends CardGeneration {
    private static AddressField cmsSpaceField;

    public ConcurrentMarkSweepGeneration(Address addr) {
        super(addr);
    }

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("ConcurrentMarkSweepGeneration");
        cmsSpaceField = type.getAddressField("_cmsSpace");
    }

    public CompactibleFreeListSpace cmsSpace() {
        return (CompactibleFreeListSpace)VMObjectFactory.newObject(CompactibleFreeListSpace.class, cmsSpaceField.getValue(this.addr));
    }

    @Override
    public long capacity() {
        return this.cmsSpace().capacity();
    }

    @Override
    public long used() {
        return this.cmsSpace().used();
    }

    @Override
    public long free() {
        return this.cmsSpace().free();
    }

    @Override
    public long contiguousAvailable() {
        throw new RuntimeException("not yet implemented");
    }

    public boolean contains(Address p) {
        return this.cmsSpace().contains(p);
    }

    @Override
    public void spaceIterate(SpaceClosure blk, boolean usedOnly) {
        blk.doSpace(this.cmsSpace());
    }

    @Override
    public Generation.Name kind() {
        return Generation.Name.CONCURRENT_MARK_SWEEP;
    }

    @Override
    public String name() {
        return "concurrent mark-sweep generation";
    }

    @Override
    public void printOn(PrintStream tty) {
        tty.println(this.name());
        this.cmsSpace().printOn(tty);
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                ConcurrentMarkSweepGeneration.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

