/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.application.snapshot;

import java.io.File;
import org.graalvm.visualvm.application.snapshot.ApplicationSnapshot;
import org.graalvm.visualvm.application.snapshot.ApplicationSnapshotProvider;
import org.graalvm.visualvm.core.snapshot.SnapshotCategory;
import org.openide.util.NbBundle;

class ApplicationSnapshotCategory
extends SnapshotCategory<ApplicationSnapshot> {
    private static final String NAME = NbBundle.getMessage(ApplicationSnapshotCategory.class, (String)"LBL_Application_Snapshots");
    private static final String PREFIX = "application";
    static final String SUFFIX = ".apps";

    ApplicationSnapshotCategory() {
        super(NAME, ApplicationSnapshot.class, PREFIX, SUFFIX, Integer.MIN_VALUE);
    }

    public boolean supportsOpenSnapshot() {
        return true;
    }

    public void openSnapshot(File file) {
        ApplicationSnapshotProvider.sharedInstance().loadSnapshotArchive(file);
    }

    boolean isSnapshotArchive(File file) {
        return file.exists() && file.isFile() && this.isSnapshot(file);
    }
}

