/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatMenuBarUI;
import com.formdev.flatlaf.ui.FlatMenuItemRenderer;
import com.formdev.flatlaf.ui.FlatMenuItemUI;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.LoggingFacade;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import java.util.function.Function;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.MenuBarUI;
import javax.swing.plaf.basic.BasicMenuUI;

public class FlatMenuUI
extends BasicMenuUI
implements FlatStylingSupport.StyleableUI {
    private FlatMenuItemRenderer renderer;
    private Map<String, Object> oldStyleValues;

    public static ComponentUI createUI(JComponent c) {
        return new FlatMenuUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.installStyle();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        LookAndFeel.installProperty(this.menuItem, "iconTextGap", FlatUIUtils.getUIInt("MenuItem.iconTextGap", 4));
        this.menuItem.setRolloverEnabled(true);
        this.renderer = this.createRenderer();
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        FlatMenuItemRenderer.clearClientProperties(this.menuItem.getParent());
        this.renderer = null;
        this.oldStyleValues = null;
    }

    protected FlatMenuItemRenderer createRenderer() {
        return new FlatMenuRenderer(this.menuItem, this.checkIcon, this.arrowIcon, this.acceleratorFont, this.acceleratorDelimiter);
    }

    @Override
    protected MouseInputListener createMouseInputListener(JComponent c) {
        return new BasicMenuUI.MouseInputHandler(){

            @Override
            public void mouseEntered(MouseEvent e) {
                super.mouseEntered(e);
                this.rollover(e, true);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                super.mouseExited(e);
                this.rollover(e, false);
            }

            private void rollover(MouseEvent e, boolean rollover) {
                JMenu menu = (JMenu)e.getSource();
                if (menu.isTopLevelMenu() && menu.isRolloverEnabled()) {
                    menu.getModel().setRollover(rollover);
                    menu.repaint();
                }
            }
        };
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener(JComponent c) {
        return FlatStylingSupport.createPropertyChangeListener(c, this::installStyle, super.createPropertyChangeListener(c));
    }

    protected void installStyle() {
        try {
            this.applyStyle(FlatStylingSupport.getResolvedStyle(this.menuItem, "Menu"));
        }
        catch (RuntimeException ex) {
            LoggingFacade.INSTANCE.logSevere(null, ex);
        }
    }

    protected void applyStyle(Object style) {
        this.oldStyleValues = FlatStylingSupport.parseAndApply(this.oldStyleValues, style, this::applyStyleProperty);
    }

    protected Object applyStyleProperty(String key, Object value) {
        try {
            return this.renderer.applyStyleProperty(key, value);
        }
        catch (FlatStylingSupport.UnknownStyleException unknownStyleException) {
            switch (key) {
                case "selectionBackground": {
                    Color oldValue = this.selectionBackground;
                    this.selectionBackground = (Color)value;
                    return oldValue;
                }
                case "selectionForeground": {
                    Color oldValue = this.selectionForeground;
                    this.selectionForeground = (Color)value;
                    return oldValue;
                }
                case "disabledForeground": {
                    Color oldValue = this.disabledForeground;
                    this.disabledForeground = (Color)value;
                    return oldValue;
                }
                case "acceleratorForeground": {
                    Color oldValue = this.acceleratorForeground;
                    this.acceleratorForeground = (Color)value;
                    return oldValue;
                }
                case "acceleratorSelectionForeground": {
                    Color oldValue = this.acceleratorSelectionForeground;
                    this.acceleratorSelectionForeground = (Color)value;
                    return oldValue;
                }
            }
            return FlatStylingSupport.applyToAnnotatedObjectOrComponent(this, this.menuItem, key, value);
        }
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos(JComponent c) {
        return FlatMenuItemUI.getStyleableInfos(this.renderer);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return ((JMenu)this.menuItem).isTopLevelMenu() ? c.getPreferredSize() : null;
    }

    @Override
    protected Dimension getPreferredMenuItemSize(JComponent c, Icon checkIcon, Icon arrowIcon, int defaultTextIconGap) {
        return this.renderer.getPreferredMenuItemSize();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        this.renderer.paintMenuItem(g, this.selectionBackground, this.selectionForeground, this.disabledForeground, this.acceleratorForeground, this.acceleratorSelectionForeground);
    }

    protected class FlatMenuRenderer
    extends FlatMenuItemRenderer {
        protected Color hoverBackground;
        protected Color menuBarUnderlineSelectionBackground;
        protected Color menuBarUnderlineSelectionColor;
        protected int menuBarUnderlineSelectionHeight;

        protected FlatMenuRenderer(JMenuItem menuItem, Icon checkIcon, Icon arrowIcon, Font acceleratorFont, String acceleratorDelimiter) {
            super(menuItem, checkIcon, arrowIcon, acceleratorFont, acceleratorDelimiter);
            this.hoverBackground = UIManager.getColor("MenuBar.hoverBackground");
            this.menuBarUnderlineSelectionBackground = FlatUIUtils.getUIColor("MenuBar.underlineSelectionBackground", this.underlineSelectionBackground);
            this.menuBarUnderlineSelectionColor = FlatUIUtils.getUIColor("MenuBar.underlineSelectionColor", this.underlineSelectionColor);
            this.menuBarUnderlineSelectionHeight = FlatUIUtils.getUIInt("MenuBar.underlineSelectionHeight", this.underlineSelectionHeight);
        }

        @Override
        protected void paintBackground(Graphics g, Color selectionBackground) {
            if (((JMenu)this.menuItem).isTopLevelMenu()) {
                ButtonModel model;
                if (this.isUnderlineSelection()) {
                    selectionBackground = this.getStyleFromMenuBarUI(ui -> ui.underlineSelectionBackground, this.menuBarUnderlineSelectionBackground);
                }
                if ((model = this.menuItem.getModel()).isRollover() && !model.isArmed() && !model.isSelected() && model.isEnabled()) {
                    g.setColor(this.deriveBackground(this.getStyleFromMenuBarUI(ui -> ui.hoverBackground, this.hoverBackground)));
                    g.fillRect(0, 0, this.menuItem.getWidth(), this.menuItem.getHeight());
                    return;
                }
            }
            super.paintBackground(g, selectionBackground);
        }

        @Override
        protected void paintUnderlineSelection(Graphics g, Color underlineSelectionColor, int underlineSelectionHeight) {
            if (((JMenu)this.menuItem).isTopLevelMenu()) {
                underlineSelectionColor = this.getStyleFromMenuBarUI(ui -> ui.underlineSelectionColor, this.menuBarUnderlineSelectionColor);
                underlineSelectionHeight = this.getStyleFromMenuBarUI(ui -> ui.underlineSelectionHeight != -1 ? Integer.valueOf(ui.underlineSelectionHeight) : null, this.menuBarUnderlineSelectionHeight);
            }
            super.paintUnderlineSelection(g, underlineSelectionColor, underlineSelectionHeight);
        }

        private <T> T getStyleFromMenuBarUI(Function<FlatMenuBarUI, T> f, T defaultValue) {
            MenuBarUI ui = ((JMenuBar)this.menuItem.getParent()).getUI();
            if (!(ui instanceof FlatMenuBarUI)) {
                return defaultValue;
            }
            T value = f.apply((FlatMenuBarUI)ui);
            return value != null ? value : defaultValue;
        }
    }
}

