/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.model;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import org.graalvm.visualvm.heapviewer.ui.UIThresholds;
import org.graalvm.visualvm.lib.ui.UIUtils;

public final class Progress {
    private volatile Set<Listener> listeners;
    private long totalSteps;
    private long currentStep;
    private boolean finished;
    private volatile long lastTick;
    private volatile long currentTick;
    private Timer timer;

    public void setupUnknownSteps() {
        this.finished = false;
        this.currentStep = 0L;
        this.totalSteps = -1L;
        this.init();
        this.fireChange();
    }

    public void setupKnownSteps(long totalSteps) {
        this.setupKnownSteps(0L, totalSteps);
    }

    public void setupKnownSteps(long currentStep, long totalSteps) {
        this.finished = false;
        this.currentStep = currentStep;
        this.totalSteps = totalSteps;
        this.init();
        this.fireChange();
    }

    public void step() {
        this.steps(1L);
    }

    public void steps(long steps) {
        this.setCurrentStep(this.currentStep + steps);
    }

    public void setCurrentStep(long currentStep) {
        if (this.finished) {
            return;
        }
        this.currentStep = currentStep;
        if (this.lastTick != this.currentTick) {
            this.fireChange();
        }
    }

    public void finish() {
        if (this.finished) {
            return;
        }
        this.finished = true;
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
        if (this.totalSteps != -1L) {
            this.currentStep = this.totalSteps;
        }
        this.fireChange();
    }

    long getCurrentStep() {
        return this.currentStep;
    }

    long getTotalSteps() {
        return this.totalSteps;
    }

    public void addChangeListener(final Listener listener) {
        UIUtils.runInEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (Progress.this.listeners == null) {
                    Progress.this.listeners = new HashSet();
                }
                Progress.this.listeners.add(listener);
            }
        });
    }

    public void removeChangeListener(final Listener listener) {
        UIUtils.runInEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (Progress.this.listeners != null) {
                    Progress.this.listeners.remove(listener);
                    if (Progress.this.listeners.isEmpty()) {
                        Progress.this.listeners = null;
                    }
                }
            }
        });
    }

    private void init() {
        this.lastTick = Long.MIN_VALUE;
        this.currentTick = Long.MIN_VALUE;
        if (this.timer == null) {
            this.timer = new Timer(UIThresholds.PROGRESS_REFRESH_RATE, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Progress.this.currentTick++;
                }
            });
            this.timer.setInitialDelay(UIThresholds.PROGRESS_INITIAL_DELAY);
            this.timer.start();
        }
    }

    private void fireChange() {
        if (this.listeners == null) {
            return;
        }
        final long _currentStep = this.currentStep;
        final long _totalSteps = this.totalSteps;
        final boolean _finished = this.finished;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (Progress.this.listeners == null || Progress.this.listeners.isEmpty()) {
                    return;
                }
                Event event = new Event(this, _currentStep, _totalSteps, _finished);
                for (Listener listener : Progress.this.listeners) {
                    listener.progressChanged(event);
                }
            }
        });
        this.lastTick = this.currentTick;
    }

    public static interface Listener {
        public void progressChanged(Event var1);
    }

    public static final class Event
    extends ChangeEvent {
        private final long currentStep;
        private final long totalSteps;
        private final boolean finished;

        private Event(Object source, long currentStep, long totalSteps, boolean finished) {
            super(source);
            this.currentStep = currentStep;
            this.totalSteps = totalSteps;
            this.finished = finished;
        }

        public long getCurrentStep() {
            return this.currentStep;
        }

        public long getTotalSteps() {
            return this.totalSteps;
        }

        public boolean isKnownSteps() {
            return this.totalSteps != -1L;
        }

        public boolean isFinished() {
            return this.finished;
        }

        @Override
        public String toString() {
            if (this.isFinished()) {
                return "finished";
            }
            if (!this.isKnownSteps()) {
                return "step " + this.currentStep;
            }
            return "step " + this.currentStep + " of " + this.totalSteps;
        }
    }
}

