/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.java.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.PriorityQueue;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.graalvm.visualvm.heapviewer.HeapContext;
import org.graalvm.visualvm.heapviewer.java.ClassNode;
import org.graalvm.visualvm.heapviewer.java.ClassNodeRenderer;
import org.graalvm.visualvm.heapviewer.java.InstanceNode;
import org.graalvm.visualvm.heapviewer.java.InstanceNodeRenderer;
import org.graalvm.visualvm.heapviewer.java.JavaHeapFragment;
import org.graalvm.visualvm.heapviewer.java.impl.Bundle;
import org.graalvm.visualvm.heapviewer.java.impl.JavaClassesProvider;
import org.graalvm.visualvm.heapviewer.java.impl.JavaObjectsView;
import org.graalvm.visualvm.heapviewer.model.DataType;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNode;
import org.graalvm.visualvm.heapviewer.swing.LinkButton;
import org.graalvm.visualvm.heapviewer.swing.Splitter;
import org.graalvm.visualvm.heapviewer.ui.HeapView;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerActions;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerNodeAction;
import org.graalvm.visualvm.heapviewer.ui.SummaryView;
import org.graalvm.visualvm.heapviewer.ui.TreeTableViewColumn;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.JavaClass;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.graalvm.visualvm.lib.ui.UIUtils;
import org.graalvm.visualvm.lib.ui.components.ProfilerToolbar;
import org.graalvm.visualvm.lib.ui.swing.ProfilerTable;
import org.graalvm.visualvm.lib.ui.swing.renderer.HideableBarRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.LabelRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.ProfilerRenderer;
import org.graalvm.visualvm.uisupport.SeparatorLine;
import org.graalvm.visualvm.uisupport.VerticalLayout;
import org.openide.util.RequestProcessor;

class JavaObjectsSummary
extends HeapView {
    private static final int PREVIEW_ITEMS = 5;
    private final HeapContext context;
    private final HeapViewerActions actions;
    private final Collection<HeapViewerNodeAction.Provider> actionProviders;
    private JComponent component;

    private JavaObjectsSummary(HeapContext context, HeapViewerActions actions, Collection<HeapViewerNodeAction.Provider> actionProviders) {
        super(Bundle.JavaObjectsSummary_Name(), Bundle.JavaObjectsSummary_Description());
        this.context = context;
        this.actions = actions;
        this.actionProviders = actionProviders;
    }

    @Override
    public JComponent getComponent() {
        if (this.component == null) {
            this.init();
        }
        return this.component;
    }

    @Override
    public ProfilerToolbar getToolbar() {
        return null;
    }

    private void init() {
        final Heap heap = this.context.getFragment().getHeap();
        final ClassNodeRenderer classRenderer = new ClassNodeRenderer(heap);
        final InstanceNodeRenderer instanceRenderer = new InstanceNodeRenderer(heap);
        TreeTableViewColumn.OwnSize sizeColumn = new TreeTableViewColumn.OwnSize(heap);
        final HideableBarRenderer sizeRenderer = (HideableBarRenderer)((TreeTableViewColumn)sizeColumn).getRenderer();
        TreeTableViewColumn.Count classesByCountColumn = new TreeTableViewColumn.Count(heap);
        final HideableBarRenderer classesByCountRenderer = (HideableBarRenderer)((TreeTableViewColumn)classesByCountColumn).getRenderer();
        Runnable classesByCountDisplayer = new Runnable(){

            @Override
            public void run() {
                JavaObjectsView objectsView = JavaObjectsSummary.this.actions.findFeature(JavaObjectsView.class);
                if (objectsView != null) {
                    objectsView.configureClassesByInstancesCount();
                    JavaObjectsSummary.this.actions.selectFeature(objectsView);
                }
            }
        };
        final ResultsSnippet classesByCount = new ResultsSnippet(Bundle.JavaObjectsSummary_ClassesInstancesCount(), classesByCountDisplayer){

            @Override
            protected void setupTable(ProfilerTable table) {
                table.setColumnRenderer(0, (ProfilerRenderer)classRenderer);
                table.setColumnRenderer(1, (ProfilerRenderer)classesByCountRenderer);
                table.setDefaultColumnWidth(1, classesByCountRenderer.getNoBarWidth() + 10);
            }
        };
        Runnable classesBySizeDisplayer = new Runnable(){

            @Override
            public void run() {
                JavaObjectsView objectsView = JavaObjectsSummary.this.actions.findFeature(JavaObjectsView.class);
                if (objectsView != null) {
                    objectsView.configureClassesByInstancesSize();
                    JavaObjectsSummary.this.actions.selectFeature(objectsView);
                }
            }
        };
        final ResultsSnippet classesBySize = new ResultsSnippet(Bundle.JavaObjectsSummary_ClassesInstancesSize(), classesBySizeDisplayer){

            @Override
            protected void setupTable(ProfilerTable table) {
                table.setColumnRenderer(0, (ProfilerRenderer)classRenderer);
                table.setColumnRenderer(1, (ProfilerRenderer)sizeRenderer);
                table.setDefaultColumnWidth(1, sizeRenderer.getNoBarWidth() + 10);
            }
        };
        Splitter classesRow = new Splitter(1, classesByCount, classesBySize);
        Runnable instancesBySizeDisplayer = new Runnable(){

            @Override
            public void run() {
                JavaObjectsView objectsView = JavaObjectsSummary.this.actions.findFeature(JavaObjectsView.class);
                if (objectsView != null) {
                    objectsView.configureInstancesBySize();
                    JavaObjectsSummary.this.actions.selectFeature(objectsView);
                }
            }
        };
        final ResultsSnippet instancesBySize = new ResultsSnippet(Bundle.JavaObjectsSummary_InstancesSize(), instancesBySizeDisplayer){

            @Override
            protected void setupTable(ProfilerTable table) {
                table.setColumnRenderer(0, (ProfilerRenderer)instanceRenderer);
                table.setColumnRenderer(1, (ProfilerRenderer)sizeRenderer);
                table.setDefaultColumnWidth(1, sizeRenderer.getNoBarWidth() + 10);
            }
        };
        final boolean retainedAvailable = DataType.RETAINED_SIZE.valuesAvailable(heap);
        Runnable dominatorsByRetainedSizeDisplayer = new Runnable(){

            @Override
            public void run() {
                JavaObjectsView objectsView = JavaObjectsSummary.this.actions.findFeature(JavaObjectsView.class);
                if (objectsView != null) {
                    objectsView.configureDominatorsByRetainedSize();
                    JavaObjectsSummary.this.actions.selectFeature(objectsView);
                }
            }
        };
        final ResultsSnippet dominatorsByRetainedSize = new ResultsSnippet(Bundle.JavaObjectsSummary_DominatorsRetainedSize(), dominatorsByRetainedSizeDisplayer){
            private Runnable retainedSizesUpdater;

            @Override
            protected JComponent createComponent() {
                if (retainedAvailable) {
                    return super.createComponent();
                }
                final JPanel p = new JPanel(new GridBagLayout());
                p.setOpaque(false);
                final JLabel l = new JLabel(Bundle.JavaObjectsSummary_ComputeRetainedSizesLbl(), 10);
                GridBagConstraints c = new GridBagConstraints();
                c.gridx = 0;
                c.gridy = 0;
                c.fill = 0;
                c.anchor = 18;
                c.insets = new Insets(2, 2, 2, 2);
                p.add((Component)l, c);
                c = new GridBagConstraints();
                c.gridx = 1;
                c.gridy = 0;
                c.weightx = 1.0;
                c.fill = 2;
                c.anchor = 18;
                c.insets = new Insets(0, 0, 0, 0);
                p.add((Component)UIUtils.createFillerPanel(), c);
                c = new GridBagConstraints();
                c.gridx = 0;
                c.gridy = 1;
                c.fill = 0;
                c.anchor = 18;
                c.insets = new Insets(2, 2, 2, 2);
                JButton lb = new JButton(Bundle.JavaObjectsSummary_ComputeRetainedSizesBtn()){

                    @Override
                    protected void fireActionPerformed(ActionEvent e) {
                        if (DataType.RETAINED_SIZE.computeValues(heap, null)) {
                            p.remove(this);
                            l.setText(Bundle.JavaObjectsSummary_ComputingRetainedSizes());
                            l.setIcon(Icons.getIcon((String)"HeapWalkerIcons.Progress"));
                            p.invalidate();
                            p.revalidate();
                            p.repaint();
                        }
                    }
                };
                final 8 rs = this;
                this.retainedSizesUpdater = new Runnable(){

                    @Override
                    public void run() {
                        new RequestProcessor("Objects Summary Retained Sizes Worker").post(new Runnable(){

                            @Override
                            public void run() {
                                JavaObjectsSummary.this.computeDominators(heap, rs);
                                retainedSizesUpdater = null;
                            }
                        });
                    }
                };
                DataType.RETAINED_SIZE.notifyWhenAvailable(heap, this.retainedSizesUpdater);
                p.add((Component)lb, c);
                c = new GridBagConstraints();
                c.gridx = 1;
                c.gridy = 1;
                c.weightx = 1.0;
                c.fill = 2;
                c.anchor = 18;
                c.insets = new Insets(0, 0, 0, 0);
                p.add((Component)UIUtils.createFillerPanel(), c);
                c = new GridBagConstraints();
                c.gridx = 0;
                c.gridy = 2;
                c.weightx = 1.0;
                c.weighty = 1.0;
                c.fill = 1;
                c.anchor = 18;
                c.insets = new Insets(0, 0, 0, 0);
                p.add((Component)UIUtils.createFillerPanel(), c);
                return p;
            }

            @Override
            protected void setupTable(ProfilerTable table) {
                table.setColumnRenderer(0, (ProfilerRenderer)instanceRenderer);
                TreeTableViewColumn.RetainedSize dominatorsByRetainedSizeColumn = new TreeTableViewColumn.RetainedSize(heap);
                HideableBarRenderer retainedRenderer = (HideableBarRenderer)((TreeTableViewColumn)dominatorsByRetainedSizeColumn).getRenderer();
                table.setColumnRenderer(1, (ProfilerRenderer)retainedRenderer);
                table.setDefaultColumnWidth(1, retainedRenderer.getNoBarWidth() + 10);
            }
        };
        Splitter instancesRow = new Splitter(1, instancesBySize, dominatorsByRetainedSize);
        this.component = new JPanel((LayoutManager)new VerticalLayout(false, 5)){

            @Override
            public Dimension getMinimumSize() {
                Dimension dim = super.getMinimumSize();
                dim.width = 0;
                return dim;
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                dim.width = 100;
                return dim;
            }
        };
        this.component.setOpaque(false);
        this.component.add(classesRow);
        this.component.add(instancesRow);
        new RequestProcessor("Objects Summary Worker").post(new Runnable(){

            @Override
            public void run() {
                Heap heap = JavaObjectsSummary.this.context.getFragment().getHeap();
                ArrayList allClasses = new ArrayList(heap.getAllClasses());
                Collections.sort(allClasses, new Comparator<JavaClass>(){

                    @Override
                    public int compare(JavaClass c1, JavaClass c2) {
                        return Integer.compare(c2.getInstancesCount(), c1.getInstancesCount());
                    }
                });
                int items = Math.min(5, allClasses.size());
                JavaClass[] classesByCountArr = allClasses.subList(0, items).toArray(new JavaClass[0]);
                Object[][] classesByCountData = new Object[classesByCountArr.length][2];
                for (int i = 0; i < classesByCountData.length; ++i) {
                    classesByCountData[i][0] = new ClassNode(classesByCountArr[i]);
                    classesByCountData[i][1] = classesByCountArr[i].getInstancesCount();
                }
                JavaObjectsSummary.this.configureSnippet(classesByCount, classesByCountData);
                Collections.sort(allClasses, new Comparator<JavaClass>(){

                    @Override
                    public int compare(JavaClass c1, JavaClass c2) {
                        return Long.compare(c2.getAllInstancesSize(), c1.getAllInstancesSize());
                    }
                });
                JavaClass[] classesBySizeArr = allClasses.subList(0, items).toArray(new JavaClass[0]);
                Object[][] classesBySizeData = new Object[classesBySizeArr.length][2];
                for (int i = 0; i < classesBySizeData.length; ++i) {
                    classesBySizeData[i][0] = new ClassNode(classesBySizeArr[i]);
                    classesBySizeData[i][1] = classesBySizeArr[i].getAllInstancesSize();
                }
                JavaObjectsSummary.this.configureSnippet(classesBySize, classesBySizeData);
                items = (int)Math.min(5L, heap.getSummary().getTotalLiveInstances());
                PriorityQueue<Instance> pqBySize = new PriorityQueue<Instance>(items, new Comparator<Instance>(){

                    @Override
                    public int compare(Instance i1, Instance i2) {
                        return Long.compare(i1.getSize(), i2.getSize());
                    }
                });
                Iterator allInstances = heap.getAllInstancesIterator();
                while (allInstances.hasNext()) {
                    Instance in = (Instance)allInstances.next();
                    if (pqBySize.size() >= items && pqBySize.peek().getSize() >= in.getSize()) continue;
                    if (pqBySize.size() == items) {
                        pqBySize.remove();
                    }
                    pqBySize.add(in);
                }
                Instance[] instancesBySizeArr = new Instance[pqBySize.size()];
                for (int i = instancesBySizeArr.length - 1; i >= 0; --i) {
                    instancesBySizeArr[i] = pqBySize.poll();
                }
                Object[][] instancesBySizeData = new Object[instancesBySizeArr.length][2];
                for (int i = 0; i < instancesBySizeData.length; ++i) {
                    instancesBySizeData[i][0] = new InstanceNode(instancesBySizeArr[i]);
                    instancesBySizeData[i][1] = instancesBySizeArr[i].getSize();
                }
                JavaObjectsSummary.this.configureSnippet(instancesBySize, instancesBySizeData);
                if (retainedAvailable) {
                    JavaObjectsSummary.this.computeDominators(heap, dominatorsByRetainedSize);
                }
            }
        });
    }

    private void computeDominators(Heap heap, ResultsSnippet dominatorsByRetainedSize) {
        ArrayList<Instance> dominators = new ArrayList<Instance>(JavaClassesProvider.getDominatorRoots(heap));
        Collections.sort(dominators, new Comparator<Instance>(){

            @Override
            public int compare(Instance i1, Instance i2) {
                return Long.compare(i2.getRetainedSize(), i1.getRetainedSize());
            }
        });
        int items = Math.min(5, dominators.size());
        Instance[] dominatorsByRetainedSizeArr = dominators.subList(0, items).toArray(new Instance[0]);
        Object[][] dominatorsByRetainedSizeData = new Object[dominatorsByRetainedSizeArr.length][2];
        for (int i = 0; i < dominatorsByRetainedSizeData.length; ++i) {
            dominatorsByRetainedSizeData[i][0] = new InstanceNode(dominatorsByRetainedSizeArr[i]);
            dominatorsByRetainedSizeData[i][1] = dominatorsByRetainedSizeArr[i].getRetainedSize();
        }
        this.configureSnippet(dominatorsByRetainedSize, dominatorsByRetainedSizeData);
    }

    private void configureSnippet(final ResultsSnippet snippet, Object[][] data) {
        final DefaultTableModel model = new DefaultTableModel(data, new Object[]{Bundle.JavaObjectsSummary_NameColumn(), Bundle.JavaObjectsSummary_ValueColumn()}){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                snippet.setRealModel(model);
            }
        });
    }

    public static class Provider
    extends SummaryView.ContentProvider {
        @Override
        public HeapView createSummary(String viewID, HeapContext context, HeapViewerActions actions, Collection<HeapViewerNodeAction.Provider> actionProviders) {
            if (JavaHeapFragment.isJavaHeap(context)) {
                return new JavaObjectsSummary(context, actions, actionProviders);
            }
            return null;
        }
    }

    private class ResultsSnippet
    extends JPanel {
        private final LinkButton link;
        private ProfilerTable table;
        private boolean keepSelection;

        ResultsSnippet(String text, final Runnable allDisplayer) {
            super(new BorderLayout(0, 6));
            this.setOpaque(false);
            this.setBorder(BorderFactory.createEmptyBorder(10, 5, 5, 5));
            JPanel sectionSeparator = new JPanel(new GridBagLayout());
            sectionSeparator.setOpaque(false);
            JLabel caption = new JLabel(text);
            caption.setFont(caption.getFont().deriveFont(1));
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.weighty = 1.0;
            sectionSeparator.add((Component)caption, c);
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = 0;
            c.insets = new Insets(0, 5, 0, 0);
            sectionSeparator.add((Component)new JLabel("["), c);
            this.link = new LinkButton(Bundle.JavaObjectsSummary_ViewAll()){

                @Override
                protected void clicked() {
                    SwingUtilities.invokeLater(allDisplayer);
                }
            };
            this.link.setEnabled(false);
            c = new GridBagConstraints();
            c.gridx = 2;
            c.gridy = 0;
            c.insets = new Insets(0, 0, 0, 0);
            sectionSeparator.add((Component)this.link, c);
            c = new GridBagConstraints();
            c.gridx = 3;
            c.gridy = 0;
            c.insets = new Insets(0, 0, 0, 0);
            sectionSeparator.add((Component)new JLabel("]"), c);
            c = new GridBagConstraints();
            c.gridx = 4;
            c.gridy = 0;
            c.weightx = 1.0;
            c.fill = 2;
            c.insets = new Insets(1, 4, 0, 0);
            sectionSeparator.add((Component)new SeparatorLine(), c);
            this.add((Component)sectionSeparator, "North");
            JComponent comp = this.createComponent();
            if (comp instanceof ProfilerTable) {
                this.table = (ProfilerTable)comp;
            }
            if (comp != null) {
                this.add((Component)comp, "Center");
            }
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension dim = super.getMinimumSize();
            dim.width = 0;
            return dim;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dim = super.getPreferredSize();
            dim.width = 100;
            return dim;
        }

        protected JComponent createComponent() {
            DefaultTableModel model = new DefaultTableModel(5, 1){
                {
                    this.setValueAt(Bundle.JavaObjectsSummary_ComputingProgress(), 0, 0);
                }

                @Override
                public boolean isCellEditable(int row, int column) {
                    return false;
                }
            };
            LabelRenderer renderer = new LabelRenderer(){

                public void setValue(Object o, int i) {
                    super.setValue(o, i);
                    this.setIcon(o == null || o.toString().isEmpty() ? null : Icons.getIcon((String)"HeapWalkerIcons.Progress"));
                }
            };
            ProfilerTable t = this.createTable(model);
            t.setDefaultRenderer(Object.class, (ProfilerRenderer)renderer);
            return t;
        }

        void setRealModel(TableModel model) {
            if (this.table == null) {
                BorderLayout bl = (BorderLayout)this.getLayout();
                Component c = bl.getLayoutComponent("Center");
                if (c != null) {
                    this.remove(c);
                }
                this.table = this.createTable(model);
                this.add((Component)this.table, "Center");
                this.getParent().invalidate();
                this.getParent().revalidate();
                this.getParent().repaint();
            }
            this.table.setModel(model);
            this.setupTable(this.table);
            this.enableTableEvents(this.table);
            this.link.setEnabled(true);
        }

        protected void setupTable(ProfilerTable table) {
        }

        private ProfilerTable createTable(TableModel model) {
            SummaryView.SimpleTable t = new SummaryView.SimpleTable(model, 0){

                protected void populatePopup(JPopupMenu popup, Object value, Object userValue) {
                    if (!(value instanceof HeapViewerNode)) {
                        return;
                    }
                    this.requestFocusInWindow();
                    HeapViewerNode node = (HeapViewerNode)((Object)value);
                    HeapViewerNodeAction.Actions nodeActions = HeapViewerNodeAction.Actions.forNode(node, JavaObjectsSummary.this.actionProviders, JavaObjectsSummary.this.context, JavaObjectsSummary.this.actions, new HeapViewerNodeAction[0]);
                    nodeActions.populatePopup(popup);
                    if (popup.getComponentCount() > 0) {
                        popup.addSeparator();
                    }
                    popup.add(this.createCopyMenuItem());
                }

                public void performDefaultAction(ActionEvent e) {
                    if (!this.getRowSelectionAllowed()) {
                        return;
                    }
                    int row = this.getSelectedRow();
                    if (row == -1) {
                        return;
                    }
                    Object value = this.getValueForRow(row);
                    if (!(value instanceof HeapViewerNode)) {
                        return;
                    }
                    HeapViewerNodeAction.Actions nodeActions = HeapViewerNodeAction.Actions.forNode((HeapViewerNode)((Object)value), JavaObjectsSummary.this.actionProviders, JavaObjectsSummary.this.context, JavaObjectsSummary.this.actions, new HeapViewerNodeAction[0]);
                    nodeActions.performDefaultAction(e);
                }

                protected void popupShowing() {
                    ResultsSnippet.this.keepSelection = true;
                }

                protected void popupHidden() {
                    ResultsSnippet.this.keepSelection = false;
                    new Timer(100, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (!this.isFocusOwner()) {
                                this.clearSelection();
                            }
                        }
                    }){
                        {
                            this.setRepeats(false);
                        }
                    }.start();
                }
            };
            return t;
        }

        private void enableTableEvents(final ProfilerTable t) {
            t.setRowSelectionAllowed(true);
            t.addFocusListener((FocusListener)new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    if (!ResultsSnippet.this.keepSelection) {
                        t.clearSelection();
                    } else {
                        ResultsSnippet.this.keepSelection = false;
                    }
                }
            });
            t.providePopupMenu(true);
            t.setSelectionOnMiddlePress(true);
            t.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (SwingUtilities.isMiddleMouseButton(e)) {
                        int row = t.getSelectedRow();
                        if (row == -1) {
                            return;
                        }
                        Object value = t.getValueForRow(row);
                        if (!(value instanceof HeapViewerNode)) {
                            return;
                        }
                        HeapViewerNode node = (HeapViewerNode)((Object)value);
                        HeapViewerNodeAction.Actions nodeActions = HeapViewerNodeAction.Actions.forNode(node, JavaObjectsSummary.this.actionProviders, JavaObjectsSummary.this.context, JavaObjectsSummary.this.actions, new HeapViewerNodeAction[0]);
                        ActionEvent ae = new ActionEvent(e.getSource(), e.getID(), "middle button", e.getWhen(), e.getModifiers());
                        nodeActions.performMiddleButtonAction(ae);
                    }
                }
            });
        }
    }
}

