/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.truffle.lang.ruby;

import org.graalvm.visualvm.heapviewer.HeapContext;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNode;
import org.graalvm.visualvm.heapviewer.truffle.TruffleObjectPreviewPlugin;
import org.graalvm.visualvm.heapviewer.truffle.TruffleObjectPropertyPlugin;
import org.graalvm.visualvm.heapviewer.truffle.lang.ruby.Bundle;
import org.graalvm.visualvm.heapviewer.truffle.lang.ruby.RubyHeapFragment;
import org.graalvm.visualvm.heapviewer.truffle.lang.ruby.RubyLanguage;
import org.graalvm.visualvm.heapviewer.truffle.lang.ruby.RubyNodes;
import org.graalvm.visualvm.heapviewer.truffle.lang.ruby.RubyObject;
import org.graalvm.visualvm.heapviewer.truffle.lang.ruby.RubyObjectProperties;
import org.graalvm.visualvm.heapviewer.truffle.lang.ruby.RubyType;
import org.graalvm.visualvm.heapviewer.ui.HeapViewPlugin;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerActions;
import org.graalvm.visualvm.lib.jfluid.heap.FieldValue;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.ObjectFieldValue;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.openide.util.Lookup;

final class RubyViewPlugins {
    RubyViewPlugins() {
    }

    public static class ReferencesPluginProvider
    extends HeapViewPlugin.Provider {
        public HeapViewPlugin createPlugin(HeapContext context, HeapViewerActions actions, String viewID) {
            if (!RubyHeapFragment.isRubyHeap(context)) {
                return null;
            }
            RubyObjectProperties.ReferencesProvider fieldsProvider = (RubyObjectProperties.ReferencesProvider)((Object)Lookup.getDefault().lookup(RubyObjectProperties.ReferencesProvider.class));
            return new TruffleObjectPropertyPlugin<RubyObject, RubyType, RubyHeapFragment, RubyLanguage>(Bundle.RubyViewPlugins_ReferencesName(), Bundle.RubyViewPlugins_ReferencesDescription(), Icons.getIcon((String)"ProfilerIcons.NodeReverse"), "ruby_objects_references", context, actions, fieldsProvider);
        }
    }

    public static class FieldsPluginProvider
    extends HeapViewPlugin.Provider {
        public HeapViewPlugin createPlugin(HeapContext context, HeapViewerActions actions, String viewID) {
            if (!RubyHeapFragment.isRubyHeap(context)) {
                return null;
            }
            RubyObjectProperties.FieldsProvider fieldsProvider = (RubyObjectProperties.FieldsProvider)((Object)Lookup.getDefault().lookup(RubyObjectProperties.FieldsProvider.class));
            return new TruffleObjectPropertyPlugin<RubyObject, RubyType, RubyHeapFragment, RubyLanguage>(Bundle.RubyViewPlugins_PropertiesName(), Bundle.RubyViewPlugins_PropertiesDescription(), Icons.getIcon((String)"ProfilerIcons.NodeForward"), "ruby_objects_fields", context, actions, fieldsProvider);
        }
    }

    public static class PreviewPluginProvider
    extends HeapViewPlugin.Provider {
        public HeapViewPlugin createPlugin(HeapContext context, HeapViewerActions actions, String viewID) {
            if (RubyHeapFragment.isRubyHeap(context)) {
                return new PreviewPlugin(context);
            }
            return null;
        }
    }

    static class PreviewPlugin
    extends TruffleObjectPreviewPlugin {
        PreviewPlugin(HeapContext context) {
            super(context);
        }

        @Override
        protected boolean supportsNode(HeapViewerNode node) {
            return node instanceof RubyNodes.RubyObjectNode;
        }

        @Override
        protected Instance getPreviewInstance(HeapViewerNode node) {
            RubyNodes.RubyObjectNode dnode = (RubyNodes.RubyObjectNode)node;
            if ("Proc".equals(dnode.getTypeName())) {
                Instance data;
                RubyObject rbobj = (RubyObject)dnode.getTruffleObject();
                FieldValue dataField = rbobj.getFieldValue("sharedMethodInfo (hidden)");
                Instance instance = data = dataField instanceof ObjectFieldValue ? ((ObjectFieldValue)dataField).getInstance() : null;
                if (data == null) {
                    return null;
                }
                Object sourceSection = data.getValueOfField("sourceSection");
                if (!(sourceSection instanceof Instance)) {
                    return null;
                }
                return (Instance)sourceSection;
            }
            return null;
        }
    }
}

