/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.truffle.lang.r;

import java.util.Iterator;
import org.graalvm.visualvm.heapviewer.HeapContext;
import org.graalvm.visualvm.heapviewer.truffle.TruffleLanguageHeapFragment;
import org.graalvm.visualvm.heapviewer.truffle.lang.r.Bundle;
import org.graalvm.visualvm.heapviewer.truffle.lang.r.RLanguage;
import org.graalvm.visualvm.heapviewer.truffle.lang.r.RObject;
import org.graalvm.visualvm.heapviewer.truffle.lang.r.RType;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;

class RHeapFragment
extends TruffleLanguageHeapFragment<RObject, RType> {
    private static final String R_HEAP_ID = "r_heap";

    RHeapFragment(RLanguage language, Instance langID, Heap heap) {
        super(R_HEAP_ID, Bundle.RHeapFragment_Name(), RHeapFragment.fragmentDescription(langID, heap), language, heap);
    }

    static RHeapFragment fromContext(HeapContext context) {
        return (RHeapFragment)context.getFragment();
    }

    @Override
    public Iterator<Instance> getInstancesIterator() {
        String[] topClasses = new String[]{"com.oracle.truffle.r.runtime.data.RBaseObject", "com.oracle.truffle.r.runtime.data.RScalarVector", "com.oracle.truffle.r.runtime.data.RForeignWrapper"};
        return this.instancesIterator(topClasses);
    }

    @Override
    public Iterator<RObject> getObjectsIterator() {
        return super.getObjectsIterator();
    }

    static boolean isRHeap(HeapContext context) {
        return R_HEAP_ID.equals(context.getFragment().getID());
    }

    public static HeapContext getRContext(HeapContext context) {
        if (RHeapFragment.isRHeap(context)) {
            return context;
        }
        for (HeapContext otherContext : context.getOtherContexts()) {
            if (!RHeapFragment.isRHeap(otherContext)) continue;
            return otherContext;
        }
        return null;
    }
}

