/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.modeler;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.management.Attribute;
import javax.management.AttributeChangeNotification;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.InvalidTargetObjectTypeException;
import javax.management.modelmbean.ModelMBeanNotificationBroadcaster;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.modeler.BaseAttributeFilter;
import org.apache.tomcat.util.modeler.BaseNotificationBroadcaster;
import org.apache.tomcat.util.modeler.ManagedBean;
import org.apache.tomcat.util.res.StringManager;

public class BaseModelMBean
implements DynamicMBean,
MBeanRegistration,
ModelMBeanNotificationBroadcaster {
    private static final Log log = LogFactory.getLog(BaseModelMBean.class);
    private static final StringManager sm = StringManager.getManager(BaseModelMBean.class);
    protected ObjectName oname = null;
    protected BaseNotificationBroadcaster attributeBroadcaster = null;
    protected BaseNotificationBroadcaster generalBroadcaster = null;
    protected ManagedBean managedBean = null;
    protected Object resource = null;
    static final Object[] NO_ARGS_PARAM = new Object[0];
    protected String resourceType = null;

    @Override
    public Object getAttribute(String string) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (string == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(sm.getString("baseModelMBean.nullAttributeName")), sm.getString("baseModelMBean.nullAttributeName"));
        }
        if (this.resource instanceof DynamicMBean && !(this.resource instanceof BaseModelMBean)) {
            return ((DynamicMBean)this.resource).getAttribute(string);
        }
        Method method = this.managedBean.getGetter(string, this, this.resource);
        Object object = null;
        try {
            Class<?> clazz = method.getDeclaringClass();
            object = clazz.isAssignableFrom(this.getClass()) ? method.invoke((Object)this, NO_ARGS_PARAM) : method.invoke(this.resource, NO_ARGS_PARAM);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable == null) {
                throwable = invocationTargetException;
            }
            if (throwable instanceof RuntimeException) {
                throw new RuntimeOperationsException((RuntimeException)throwable, sm.getString("baseModelMBean.invokeError", new Object[]{string}));
            }
            if (throwable instanceof Error) {
                throw new RuntimeErrorException((Error)throwable, sm.getString("baseModelMBean.invokeError", new Object[]{string}));
            }
            throw new MBeanException(invocationTargetException, sm.getString("baseModelMBean.invokeError", new Object[]{string}));
        }
        catch (Exception exception) {
            throw new MBeanException(exception, sm.getString("baseModelMBean.invokeError", new Object[]{string}));
        }
        return object;
    }

    @Override
    public AttributeList getAttributes(String[] stringArray) {
        if (stringArray == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(sm.getString("baseModelMBean.nullAttributeNameList")), sm.getString("baseModelMBean.nullAttributeNameList"));
        }
        AttributeList attributeList = new AttributeList();
        for (String string : stringArray) {
            try {
                attributeList.add(new Attribute(string, this.getAttribute(string)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return attributeList;
    }

    public void setManagedBean(ManagedBean managedBean) {
        this.managedBean = managedBean;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this.managedBean.getMBeanInfo();
    }

    @Override
    public Object invoke(String string, Object[] objectArray, String[] stringArray) throws MBeanException, ReflectionException {
        if (this.resource instanceof DynamicMBean && !(this.resource instanceof BaseModelMBean)) {
            return ((DynamicMBean)this.resource).invoke(string, objectArray, stringArray);
        }
        if (string == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(sm.getString("baseModelMBean.nullMethodName")), sm.getString("baseModelMBean.nullMethodName"));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Invoke " + string));
        }
        Method method = this.managedBean.getInvoke(string, objectArray, stringArray, this, this.resource);
        Object object = null;
        try {
            object = method.getDeclaringClass().isAssignableFrom(this.getClass()) ? method.invoke((Object)this, objectArray) : method.invoke(this.resource, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            log.error((Object)sm.getString("baseModelMBean.invokeError", new Object[]{string}), throwable);
            if (throwable == null) {
                throwable = invocationTargetException;
            }
            if (throwable instanceof RuntimeException) {
                throw new RuntimeOperationsException((RuntimeException)throwable, sm.getString("baseModelMBean.invokeError", new Object[]{string}));
            }
            if (throwable instanceof Error) {
                throw new RuntimeErrorException((Error)throwable, sm.getString("baseModelMBean.invokeError", new Object[]{string}));
            }
            throw new MBeanException((Exception)throwable, sm.getString("baseModelMBean.invokeError", new Object[]{string}));
        }
        catch (Exception exception) {
            log.error((Object)sm.getString("baseModelMBean.invokeError", new Object[]{string}), (Throwable)exception);
            throw new MBeanException(exception, sm.getString("baseModelMBean.invokeError", new Object[]{string}));
        }
        return object;
    }

    static Class<?> getAttributeClass(String string) throws ReflectionException {
        if (string.equals(Boolean.TYPE.getName())) {
            return Boolean.TYPE;
        }
        if (string.equals(Byte.TYPE.getName())) {
            return Byte.TYPE;
        }
        if (string.equals(Character.TYPE.getName())) {
            return Character.TYPE;
        }
        if (string.equals(Double.TYPE.getName())) {
            return Double.TYPE;
        }
        if (string.equals(Float.TYPE.getName())) {
            return Float.TYPE;
        }
        if (string.equals(Integer.TYPE.getName())) {
            return Integer.TYPE;
        }
        if (string.equals(Long.TYPE.getName())) {
            return Long.TYPE;
        }
        if (string.equals(Short.TYPE.getName())) {
            return Short.TYPE;
        }
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader != null) {
                return classLoader.loadClass(string);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ReflectionException(classNotFoundException, sm.getString("baseModelMBean.cnfeForSignature", new Object[]{string}));
        }
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting attribute " + this + " " + attribute));
        }
        if (this.resource instanceof DynamicMBean && !(this.resource instanceof BaseModelMBean)) {
            try {
                ((DynamicMBean)this.resource).setAttribute(attribute);
            }
            catch (InvalidAttributeValueException invalidAttributeValueException) {
                throw new MBeanException(invalidAttributeValueException);
            }
            return;
        }
        if (attribute == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(sm.getString("baseModelMBean.nullAttribute")), sm.getString("baseModelMBean.nullAttribute"));
        }
        String string = attribute.getName();
        Object object = attribute.getValue();
        if (string == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(sm.getString("baseModelMBean.nullAttributeName")), sm.getString("baseModelMBean.nullAttributeName"));
        }
        Object var4_5 = null;
        Method method = this.managedBean.getSetter(string, this, this.resource);
        try {
            if (method.getDeclaringClass().isAssignableFrom(this.getClass())) {
                method.invoke((Object)this, object);
            } else {
                method.invoke(this.resource, object);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable == null) {
                throwable = invocationTargetException;
            }
            if (throwable instanceof RuntimeException) {
                throw new RuntimeOperationsException((RuntimeException)throwable, sm.getString("baseModelMBean.invokeError", new Object[]{string}));
            }
            if (throwable instanceof Error) {
                throw new RuntimeErrorException((Error)throwable, sm.getString("baseModelMBean.invokeError", new Object[]{string}));
            }
            throw new MBeanException(invocationTargetException, sm.getString("baseModelMBean.invokeError", new Object[]{string}));
        }
        catch (Exception exception) {
            log.error((Object)sm.getString("baseModelMBean.invokeError", new Object[]{string}), (Throwable)exception);
            throw new MBeanException(exception, sm.getString("baseModelMBean.invokeError", new Object[]{string}));
        }
        try {
            this.sendAttributeChangeNotification(new Attribute(string, var4_5), attribute);
        }
        catch (Exception exception) {
            log.error((Object)sm.getString("baseModelMBean.notificationError", new Object[]{string}), (Throwable)exception);
        }
    }

    public String toString() {
        if (this.resource == null) {
            return "BaseModelMbean[" + this.resourceType + "]";
        }
        return this.resource.toString();
    }

    @Override
    public AttributeList setAttributes(AttributeList attributeList) {
        AttributeList attributeList2 = new AttributeList();
        if (attributeList == null) {
            return attributeList2;
        }
        String[] stringArray = new String[attributeList.size()];
        int n = 0;
        for (Object e : attributeList) {
            Attribute attribute = (Attribute)e;
            stringArray[n++] = attribute.getName();
            try {
                this.setAttribute(attribute);
            }
            catch (Exception exception) {}
        }
        return this.getAttributes(stringArray);
    }

    public Object getManagedResource() throws InstanceNotFoundException, InvalidTargetObjectTypeException, MBeanException, RuntimeOperationsException {
        if (this.resource == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(sm.getString("baseModelMBean.nullResource")), sm.getString("baseModelMBean.nullResource"));
        }
        return this.resource;
    }

    public void setManagedResource(Object object, String string) throws InstanceNotFoundException, MBeanException, RuntimeOperationsException {
        if (object == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(sm.getString("baseModelMBean.nullResource")), sm.getString("baseModelMBean.nullResource"));
        }
        this.resource = object;
        this.resourceType = object.getClass().getName();
    }

    @Override
    public void addAttributeChangeNotificationListener(NotificationListener notificationListener, String string, Object object) throws IllegalArgumentException {
        if (notificationListener == null) {
            throw new IllegalArgumentException(sm.getString("baseModelMBean.nullListener"));
        }
        if (this.attributeBroadcaster == null) {
            this.attributeBroadcaster = new BaseNotificationBroadcaster();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("addAttributeNotificationListener " + notificationListener));
        }
        BaseAttributeFilter baseAttributeFilter = new BaseAttributeFilter(string);
        this.attributeBroadcaster.addNotificationListener(notificationListener, baseAttributeFilter, object);
    }

    @Override
    public void removeAttributeChangeNotificationListener(NotificationListener notificationListener, String string) throws ListenerNotFoundException {
        if (notificationListener == null) {
            throw new IllegalArgumentException(sm.getString("baseModelMBean.nullListener"));
        }
        if (this.attributeBroadcaster != null) {
            this.attributeBroadcaster.removeNotificationListener(notificationListener);
        }
    }

    @Override
    public void sendAttributeChangeNotification(AttributeChangeNotification attributeChangeNotification) throws MBeanException, RuntimeOperationsException {
        if (attributeChangeNotification == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(sm.getString("baseModelMBean.nullNotification")), sm.getString("baseModelMBean.nullNotification"));
        }
        if (this.attributeBroadcaster == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("AttributeChangeNotification " + attributeChangeNotification));
        }
        this.attributeBroadcaster.sendNotification(attributeChangeNotification);
    }

    @Override
    public void sendAttributeChangeNotification(Attribute attribute, Attribute attribute2) throws MBeanException, RuntimeOperationsException {
        String string = null;
        if (attribute2.getValue() != null) {
            string = attribute2.getValue().getClass().getName();
        } else if (attribute.getValue() != null) {
            string = attribute.getValue().getClass().getName();
        } else {
            return;
        }
        AttributeChangeNotification attributeChangeNotification = new AttributeChangeNotification(this, 1L, System.currentTimeMillis(), "Attribute value has changed", attribute.getName(), string, attribute.getValue(), attribute2.getValue());
        this.sendAttributeChangeNotification(attributeChangeNotification);
    }

    @Override
    public void sendNotification(Notification notification) throws MBeanException, RuntimeOperationsException {
        if (notification == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(sm.getString("baseModelMBean.nullNotification")), sm.getString("baseModelMBean.nullNotification"));
        }
        if (this.generalBroadcaster == null) {
            return;
        }
        this.generalBroadcaster.sendNotification(notification);
    }

    @Override
    public void sendNotification(String string) throws MBeanException, RuntimeOperationsException {
        if (string == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(sm.getString("baseModelMBean.nullMessage")), sm.getString("baseModelMBean.nullMessage"));
        }
        Notification notification = new Notification("jmx.modelmbean.generic", (Object)this, 1L, string);
        this.sendNotification(notification);
    }

    @Override
    public void addNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws IllegalArgumentException {
        if (notificationListener == null) {
            throw new IllegalArgumentException(sm.getString("baseModelMBean.nullListener"));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("addNotificationListener " + notificationListener));
        }
        if (this.generalBroadcaster == null) {
            this.generalBroadcaster = new BaseNotificationBroadcaster();
        }
        this.generalBroadcaster.addNotificationListener(notificationListener, notificationFilter, object);
        if (this.attributeBroadcaster == null) {
            this.attributeBroadcaster = new BaseNotificationBroadcaster();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("addAttributeNotificationListener " + notificationListener));
        }
        this.attributeBroadcaster.addNotificationListener(notificationListener, notificationFilter, object);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        MBeanNotificationInfo[] mBeanNotificationInfoArray = this.getMBeanInfo().getNotifications();
        MBeanNotificationInfo[] mBeanNotificationInfoArray2 = new MBeanNotificationInfo[mBeanNotificationInfoArray.length + 2];
        mBeanNotificationInfoArray2[0] = new MBeanNotificationInfo(new String[]{"jmx.modelmbean.generic"}, "GENERIC", "Text message notification from the managed resource");
        mBeanNotificationInfoArray2[1] = new MBeanNotificationInfo(new String[]{"jmx.attribute.change"}, "ATTRIBUTE_CHANGE", "Observed MBean attribute value has changed");
        System.arraycopy(mBeanNotificationInfoArray, 0, mBeanNotificationInfoArray2, 2, mBeanNotificationInfoArray.length);
        return mBeanNotificationInfoArray2;
    }

    @Override
    public void removeNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException {
        if (notificationListener == null) {
            throw new IllegalArgumentException(sm.getString("baseModelMBean.nullListener"));
        }
        if (this.generalBroadcaster != null) {
            this.generalBroadcaster.removeNotificationListener(notificationListener);
        }
        if (this.attributeBroadcaster != null) {
            this.attributeBroadcaster.removeNotificationListener(notificationListener);
        }
    }

    public String getModelerType() {
        return this.resourceType;
    }

    public String getClassName() {
        return this.getModelerType();
    }

    public ObjectName getJmxName() {
        return this.oname;
    }

    public String getObjectName() {
        if (this.oname != null) {
            return this.oname.toString();
        }
        return null;
    }

    @Override
    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("preRegister " + this.resource + " " + objectName));
        }
        this.oname = objectName;
        if (this.resource instanceof MBeanRegistration) {
            this.oname = ((MBeanRegistration)this.resource).preRegister(mBeanServer, objectName);
        }
        return this.oname;
    }

    @Override
    public void postRegister(Boolean bl) {
        if (this.resource instanceof MBeanRegistration) {
            ((MBeanRegistration)this.resource).postRegister(bl);
        }
    }

    @Override
    public void preDeregister() throws Exception {
        if (this.resource instanceof MBeanRegistration) {
            ((MBeanRegistration)this.resource).preDeregister();
        }
    }

    @Override
    public void postDeregister() {
        if (this.resource instanceof MBeanRegistration) {
            ((MBeanRegistration)this.resource).postDeregister();
        }
    }
}

