import { CloudFormationClient } from "../CloudFormationClient";
import { DescribeStackResourceDriftsCommand, } from "../commands/DescribeStackResourceDriftsCommand";
const makePagedClientRequest = async (client, input, ...args) => {
    return await client.send(new DescribeStackResourceDriftsCommand(input), ...args);
};
export async function* paginateDescribeStackResourceDrifts(config, input, ...additionalArguments) {
    let token = config.startingToken || undefined;
    let hasNext = true;
    let page;
    while (hasNext) {
        input.NextToken = token;
        input["MaxResults"] = config.pageSize;
        if (config.client instanceof CloudFormationClient) {
            page = await makePagedClientRequest(config.client, input, ...additionalArguments);
        }
        else {
            throw new Error("Invalid client, expected CloudFormation | CloudFormationClient");
        }
        yield page;
        const prevToken = token;
        token = page.NextToken;
        hasNext = !!(token && (!config.stopOnSameToken || token !== prevToken));
    }
    return undefined;
}
