/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import org.scilab.forge.jlatexmath.Box;

public class HorizontalRule
extends Box {
    private Color color = null;
    private float speShift = 0.0f;

    public HorizontalRule(float thickness, float width, float s2) {
        this.height = thickness;
        this.width = width;
        this.shift = s2;
    }

    public HorizontalRule(float thickness, float width, float s2, boolean trueShift) {
        this.height = thickness;
        this.width = width;
        if (trueShift) {
            this.shift = s2;
        } else {
            this.shift = 0.0f;
            this.speShift = s2;
        }
    }

    public HorizontalRule(float thickness, float width, float s2, Color c) {
        this.height = thickness;
        this.width = width;
        this.color = c;
        this.shift = s2;
    }

    @Override
    public void draw(Graphics2D g2, float x, float y) {
        Color old = g2.getColor();
        if (this.color != null) {
            g2.setColor(this.color);
        }
        if (this.speShift == 0.0f) {
            g2.fill(new Rectangle2D.Float(x, y - this.height, this.width, this.height));
        } else {
            g2.fill(new Rectangle2D.Float(x, y - this.height + this.speShift, this.width, this.height));
        }
        g2.setColor(old);
    }

    @Override
    public int getLastFontId() {
        return -1;
    }
}

