/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.reindex;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.function.Consumer;
import org.opensearch.action.ActionType;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.reindex.AbstractBaseReindexRestHandler;
import org.opensearch.index.reindex.AbstractBulkByScrollRequest;
import org.opensearch.index.reindex.BulkByScrollResponse;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.search.RestSearchAction;

public abstract class AbstractBulkByQueryRestHandler<Request extends AbstractBulkByScrollRequest<Request>, A extends ActionType<BulkByScrollResponse>>
extends AbstractBaseReindexRestHandler<Request, A> {
    protected AbstractBulkByQueryRestHandler(A action) {
        super(action);
    }

    protected void parseInternalRequest(Request internal, RestRequest restRequest, NamedWriteableRegistry namedWriteableRegistry, Map<String, Consumer<Object>> bodyConsumers) throws IOException {
        assert (internal != null) : "Request should not be null";
        assert (restRequest != null) : "RestRequest should not be null";
        SearchRequest searchRequest = internal.getSearchRequest();
        try (XContentParser parser = this.extractRequestSpecificFields(restRequest, bodyConsumers);){
            RestSearchAction.parseSearchRequest((SearchRequest)searchRequest, (RestRequest)restRequest, (XContentParser)parser, (NamedWriteableRegistry)namedWriteableRegistry, size -> this.setMaxDocsFromSearchSize(internal, size));
        }
        searchRequest.source().size(restRequest.paramAsInt("scroll_size", searchRequest.source().size()));
        String conflicts = restRequest.param("conflicts");
        if (conflicts != null) {
            internal.setConflicts(conflicts);
        }
        if (restRequest.hasParam("search_timeout")) {
            searchRequest.source().timeout(restRequest.paramAsTime("search_timeout", null));
        }
    }

    private XContentParser extractRequestSpecificFields(RestRequest restRequest, Map<String, Consumer<Object>> bodyConsumers) throws IOException {
        if (!restRequest.hasContentOrSourceParam()) {
            return null;
        }
        try (XContentParser parser = restRequest.contentOrSourceParamParser();){
            XContentParser xContentParser;
            block14: {
                XContentBuilder builder = MediaTypeRegistry.contentBuilder((MediaType)parser.contentType());
                try {
                    Map body = parser.map();
                    for (Map.Entry<String, Consumer<Object>> consumer : bodyConsumers.entrySet()) {
                        Object value = body.remove(consumer.getKey());
                        if (value == null) continue;
                        consumer.getValue().accept(value);
                    }
                    xContentParser = parser.contentType().xContent().createParser(parser.getXContentRegistry(), parser.getDeprecationHandler(), (InputStream)BytesReference.bytes((XContentBuilder)builder.map(body)).streamInput());
                    if (builder == null) break block14;
                }
                catch (Throwable throwable) {
                    if (builder != null) {
                        try {
                            builder.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                builder.close();
            }
            return xContentParser;
        }
    }

    private void setMaxDocsFromSearchSize(Request request, int size) {
        LoggingDeprecationHandler.INSTANCE.usedDeprecatedName(null, null, "size", "max_docs");
        AbstractBulkByQueryRestHandler.setMaxDocsValidateIdentical(request, size);
    }
}

