/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.apt.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVisitor;
import org.eclipse.jdt.internal.compiler.apt.dispatch.BaseProcessingEnvImpl;
import org.eclipse.jdt.internal.compiler.apt.model.TypeMirrorImpl;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;

public class DeclaredTypeImpl
extends TypeMirrorImpl
implements DeclaredType {
    private final ElementKind _elementKindHint;

    DeclaredTypeImpl(BaseProcessingEnvImpl baseProcessingEnvImpl, ReferenceBinding referenceBinding) {
        super(baseProcessingEnvImpl, referenceBinding);
        this._elementKindHint = null;
    }

    DeclaredTypeImpl(BaseProcessingEnvImpl baseProcessingEnvImpl, ReferenceBinding referenceBinding, ElementKind elementKind) {
        super(baseProcessingEnvImpl, referenceBinding);
        this._elementKindHint = elementKind;
    }

    @Override
    public Element asElement() {
        TypeBinding typeBinding = null;
        if (this._binding instanceof TypeBinding) {
            typeBinding = ((TypeBinding)this._binding).prototype();
        }
        if (typeBinding != null) {
            return this._env.getFactory().newElement(typeBinding, this._elementKindHint);
        }
        return this._env.getFactory().newElement((ReferenceBinding)this._binding, this._elementKindHint);
    }

    @Override
    public TypeMirror getEnclosingType() {
        ReferenceBinding referenceBinding = (ReferenceBinding)this._binding;
        ReferenceBinding referenceBinding2 = referenceBinding.enclosingType();
        if (referenceBinding2 != null) {
            return this._env.getFactory().newTypeMirror(referenceBinding2);
        }
        return this._env.getFactory().getNoType(TypeKind.NONE);
    }

    @Override
    public List<? extends TypeMirror> getTypeArguments() {
        ReferenceBinding referenceBinding = (ReferenceBinding)this._binding;
        if (referenceBinding.isParameterizedType()) {
            int n;
            ParameterizedTypeBinding parameterizedTypeBinding = (ParameterizedTypeBinding)this._binding;
            TypeBinding[] typeBindingArray = parameterizedTypeBinding.arguments;
            int n2 = n = typeBindingArray == null ? 0 : typeBindingArray.length;
            if (n == 0) {
                return Collections.emptyList();
            }
            ArrayList<TypeMirror> arrayList = new ArrayList<TypeMirror>(n);
            for (TypeBinding typeBinding : typeBindingArray) {
                arrayList.add(this._env.getFactory().newTypeMirror(typeBinding));
            }
            return Collections.unmodifiableList(arrayList);
        }
        if (referenceBinding.isGenericType()) {
            TypeVariableBinding[] typeVariableBindingArray = referenceBinding.typeVariables();
            ArrayList<TypeMirror> arrayList = new ArrayList<TypeMirror>(typeVariableBindingArray.length);
            for (TypeVariableBinding typeVariableBinding : typeVariableBindingArray) {
                arrayList.add(this._env.getFactory().newTypeMirror(typeVariableBinding));
            }
            return Collections.unmodifiableList(arrayList);
        }
        return Collections.emptyList();
    }

    @Override
    public <R, P> R accept(TypeVisitor<R, P> typeVisitor, P p) {
        return typeVisitor.visitDeclared(this, p);
    }

    @Override
    public TypeKind getKind() {
        return TypeKind.DECLARED;
    }

    @Override
    public String toString() {
        return new String(this._binding.readableName());
    }
}

