/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.internal.compiler.util.CtSym;
import org.eclipse.jdt.internal.compiler.util.JRTUtil;
import org.eclipse.jdt.internal.compiler.util.JrtFileSystem;

class JrtFileSystemWithOlderRelease
extends JrtFileSystem {
    final String release;
    private List<Path> releaseRoots = Collections.emptyList();
    protected Path modulePath;
    private CtSym ctSym;

    JrtFileSystemWithOlderRelease(File file, String string) throws IOException {
        super(file);
        this.release = string;
        this.initialize(file, string);
    }

    @Override
    void initialize(File file) throws IOException {
    }

    private void initialize(File file, String string) throws IOException {
        super.initialize(file);
        this.fs = null;
        String string2 = CtSym.getReleaseCode(this.release);
        this.ctSym = JRTUtil.getCtSym(Paths.get(this.jdkHome, new String[0]));
        this.fs = this.ctSym.getFs();
        if (!Files.exists(this.fs.getPath(string2, new String[0]), new LinkOption[0]) || Files.exists(this.fs.getPath(string2, "system-modules"), new LinkOption[0])) {
            this.fs = null;
        }
        this.releaseRoots = this.ctSym.releaseRoots(string2);
    }

    @Override
    void walkModuleImage(final JRTUtil.JrtFileVisitor<Path> jrtFileVisitor, final int n) throws IOException {
        for (Path path : this.releaseRoots) {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new JRTUtil.AbstractFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                    int n2 = path.getNameCount();
                    if (n2 == 1) {
                        return FileVisitResult.CONTINUE;
                    }
                    if (n2 == 2) {
                        Path path2 = path.getName(1);
                        if (JRTUtil.MODULE_TO_LOAD != null && JRTUtil.MODULE_TO_LOAD.length() > 0 && JRTUtil.MODULE_TO_LOAD.indexOf(path2.toString()) == -1) {
                            return FileVisitResult.SKIP_SUBTREE;
                        }
                        return (n & 4) == 0 ? FileVisitResult.CONTINUE : jrtFileVisitor.visitModule(path, JRTUtil.sanitizedFileName(path2));
                    }
                    if ((n & 2) == 0) {
                        return FileVisitResult.CONTINUE;
                    }
                    return jrtFileVisitor.visitPackage(path.subpath(2, n2), path.getName(1), basicFileAttributes);
                }

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                    if ((n & 1) == 0) {
                        return FileVisitResult.CONTINUE;
                    }
                    if (path.getNameCount() == 3) {
                        JrtFileSystemWithOlderRelease.this.cachePackage("", path.getName(1).toString());
                    }
                    return jrtFileVisitor.visitFile(path.subpath(2, path.getNameCount()), path.getName(1), basicFileAttributes);
                }
            });
        }
    }
}

