/*
 * Decompiled with CFR 0.152.
 */
package bt747.j2se_view.model;

import bt747.j2se_view.J2SEAppModel;
import bt747.j2se_view.helpers.TaggedFilePathFactory;
import bt747.j2se_view.model.BT747Waypoint;
import bt747.j2se_view.model.FileWaypoint;
import bt747.j2se_view.model.ImageData;
import bt747.j2se_view.model.MapWaypoint;
import bt747.model.Controller;
import bt747.model.ModelEvent;
import bt747.sys.Generic;
import bt747.sys.interfaces.BT747Path;
import gps.log.GPSRecord;
import gps.log.out.CommonOut;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractListModel;
import net.sf.bt747.j2se.app.filefilters.KnownFileFilter;
import net.sf.bt747.j2se.app.utils.GPSRecordTimeComparator;
import org.jdesktop.beans.AbstractBean;

public final class PositionData
extends AbstractBean {
    private J2SEAppModel m;
    private List<List<GPSRecord>> trks = new Vector<List<GPSRecord>>();
    private final Vector<MapWaypoint> wayPoints = new Vector();
    private final Vector<MapWaypoint> userWayPoints = new Vector();
    private UserWayPointListModel userWpListModel = new UserWayPointListModel(this);

    public PositionData() {
    }

    public PositionData(J2SEAppModel j2SEAppModel) {
        this.m = j2SEAppModel;
    }

    public final List<List<GPSRecord>> getTracks() {
        return this.trks;
    }

    public final void setTracks(List<List<GPSRecord>> list) {
        this.trks = list;
        this.fireTrackPointListChange();
    }

    public final GPSRecord[] getWayPoints() {
        GPSRecord[] gPSRecordArray = new GPSRecord[this.wayPoints.size()];
        int n = 0;
        for (MapWaypoint mapWaypoint : this.wayPoints) {
            gPSRecordArray[n++] = mapWaypoint.wpt.getGpsRecord();
        }
        return gPSRecordArray;
    }

    public final List<MapWaypoint> getBT747Waypoints() {
        return this.wayPoints;
    }

    public final List<MapWaypoint> getBT747UserWaypoints() {
        return this.userWayPoints;
    }

    public final void setWayPoints(GPSRecord[] gPSRecordArray) {
        this.wayPoints.removeAllElements();
        if (gPSRecordArray != null) {
            for (GPSRecord gPSRecord : gPSRecordArray) {
                this.wayPoints.add(new MapWaypoint(gPSRecord));
            }
        }
        this.fireWaypointListUpdate();
    }

    public final List<MapWaypoint> getUserWayPoints() {
        return this.userWayPoints;
    }

    public final void userWaypointsUpdated() {
        this.fireUserWaypointUpdate();
    }

    public final void dataUpdated() {
        this.fireTrackPointListChange();
        this.fireWaypointListUpdate();
        this.fireUserWaypointUpdate();
    }

    private void fireWaypointListUpdate() {
        this.postEvent(new ModelEvent(1000, null));
    }

    private void fireUserWaypointUpdate() {
        this.userWpListModel.fireContentsChanged(this.userWpListModel, 0, this.userWpListModel.getSize() - 1);
        this.postEvent(new ModelEvent(1002, null));
    }

    private final void fireTrackPointListChange() {
        this.postEvent(new ModelEvent(1001, this.trks));
    }

    private final void postEvent(ModelEvent modelEvent) {
        if (this.m != null) {
            this.m.postEvent(modelEvent);
        }
    }

    public final UserWayPointListModel getWaypointListModel() {
        return this.userWpListModel;
    }

    public final GPSRecord[] getSortedWaypointGPSRecords() {
        GPSRecord[] gPSRecordArray = new GPSRecord[this.userWayPoints.size()];
        int n = 0;
        Iterator<MapWaypoint> iterator = this.userWayPoints.iterator();
        while (iterator.hasNext()) {
            GPSRecord gPSRecord = iterator.next().wpt.getGpsRecord();
            if (gPSRecord != null) {
                gPSRecordArray[n++] = gPSRecord;
                continue;
            }
            GPSRecord.getLogFormatRecord(0);
            Generic.debug("Null GPS Record found");
        }
        Arrays.sort(gPSRecordArray, new GPSRecordTimeComparator());
        return gPSRecordArray;
    }

    public final void addFiles(File[] fileArray) {
        if (fileArray != null) {
            KnownFileFilter knownFileFilter = new KnownFileFilter();
            for (int i = 0; i < fileArray.length; ++i) {
                try {
                    File file = fileArray[i];
                    if (file.exists()) {
                        String string = fileArray[i].getCanonicalPath();
                        if (knownFileFilter.accept(file)) {
                            Controller.addLogFile(new BT747Path(string));
                            continue;
                        }
                        this.userWpListModel.add(string);
                        continue;
                    }
                    System.err.println("File not found: " + file.getCanonicalPath());
                    continue;
                }
                catch (IOException iOException) {
                    Generic.debug("Issue with adding a file", iOException);
                }
            }
            this.postEvent(new ModelEvent(271, null));
        }
    }

    public static final Object getData(MapWaypoint object, int n) {
        object = object.wpt;
        Object object2 = TaggedFilePathFactory.getValue(((BT747Waypoint)object).getGpsRecord(), n);
        if (object2 == null) {
            FileWaypoint fileWaypoint;
            if (object instanceof FileWaypoint) {
                fileWaypoint = (FileWaypoint)object;
                switch (n) {
                    case 46: {
                        return CommonOut.getDateStr(fileWaypoint.getUtc());
                    }
                    case 47: {
                        return CommonOut.getTimeStr(fileWaypoint.getUtc());
                    }
                    case 45: {
                        return CommonOut.getDateTimeStr(fileWaypoint.getUtc());
                    }
                    case 35: {
                        return fileWaypoint.getFilePath();
                    }
                }
            }
            if (object instanceof ImageData) {
                fileWaypoint = (ImageData)object;
                switch (n) {
                    case 36: {
                        return ((ImageData)fileWaypoint).getWidth();
                    }
                    case 37: {
                        return ((ImageData)fileWaypoint).getHeight();
                    }
                    case 38: {
                        if (((ImageData)fileWaypoint).getWidth() == 0) break;
                        return ((ImageData)fileWaypoint).getWidth() + "x" + ((ImageData)fileWaypoint).getHeight();
                    }
                }
            }
        }
        return object2;
    }

    public final class UserWayPointListModel
    extends AbstractListModel
    implements PropertyChangeListener {
        private Hashtable<String, FileWaypoint> imageTable = new Hashtable();
        private /* synthetic */ PositionData this$0;

        public UserWayPointListModel(PositionData positionData) {
            this.this$0 = positionData;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void add(String string) {
            Hashtable<String, FileWaypoint> hashtable = this.imageTable;
            synchronized (hashtable) {
                if (!this.imageTable.contains(string)) {
                    FileWaypoint fileWaypoint = new ImageData();
                    if (fileWaypoint.setFilePath(new BT747Path(string))) {
                        this.add(fileWaypoint);
                    } else {
                        fileWaypoint = new FileWaypoint();
                        fileWaypoint.setFilePath(new BT747Path(string));
                        this.add(fileWaypoint);
                    }
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void add(FileWaypoint object) {
            Hashtable<String, FileWaypoint> hashtable = this.imageTable;
            synchronized (hashtable) {
                this.imageTable.put(((FileWaypoint)object).getFilePath().getPath(), (FileWaypoint)object);
                MapWaypoint mapWaypoint = new MapWaypoint((BT747Waypoint)object);
                object = this;
                Vector vector = ((UserWayPointListModel)object).this$0.userWayPoints;
                synchronized (vector) {
                    ((UserWayPointListModel)object).this$0.userWayPoints.add(mapWaypoint);
                    int n = ((UserWayPointListModel)object).this$0.userWayPoints.size() - 1;
                    mapWaypoint.addPropertyChangeListener((PropertyChangeListener)object);
                    ((UserWayPointListModel)object).fireIntervalAdded(object, n, n);
                }
                return;
            }
        }

        public final void remove(Object[] objectArray) {
            int n = this.imageTable.size() - 1;
            for (Object object : objectArray) {
                if (object instanceof ImageData) {
                    ImageData imageData = (ImageData)object;
                    this.imageTable.remove(imageData.getFilePath());
                }
                this.this$0.userWayPoints.remove(object);
            }
            this.this$0.userWpListModel.fireIntervalRemoved(this, 0, n);
        }

        public final void clear() {
            int n = this.this$0.userWayPoints.size();
            this.this$0.userWayPoints.removeAllElements();
            this.imageTable.clear();
            this.this$0.userWpListModel.fireIntervalRemoved(this.this$0.userWpListModel, 0, n - 1);
        }

        @Override
        public final Object getElementAt(int n) {
            if (n >= 0 && n < this.this$0.userWayPoints.size()) {
                return this.this$0.userWayPoints.get(n);
            }
            return null;
        }

        @Override
        public final int getSize() {
            return this.this$0.userWayPoints.size();
        }

        @Override
        protected final void fireContentsChanged(Object object, int n, int n2) {
            super.fireContentsChanged(object, n, n2);
        }

        @Override
        protected final void fireIntervalAdded(Object object, int n, int n2) {
            super.fireIntervalAdded(object, n, n2);
        }

        public final void fireChange(int n) {
            super.fireContentsChanged(this, n, n);
        }

        @Override
        protected final void fireIntervalRemoved(Object object, int n, int n2) {
            super.fireIntervalRemoved(object, n, n2);
        }

        @Override
        public final void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("selected")) {
                this.this$0.firePropertyChange("wpdisplaychange", null, Boolean.TRUE);
                try {
                    if (((Boolean)propertyChangeEvent.getNewValue()).booleanValue()) {
                        this.this$0.firePropertyChange("selectedwaypoint", null, (Object)((MapWaypoint)((Object)propertyChangeEvent.getSource())));
                    }
                    return;
                }
                catch (Exception exception) {
                    return;
                }
            }
            if (propertyChangeEvent.getPropertyName().equals("showtag")) {
                this.this$0.firePropertyChange("wpdisplaychange", null, Boolean.TRUE);
            }
        }
    }
}

