complete -c sshd-openpgp-auth -n "__fish_use_subcommand" -s h -l help -d 'Print help'
complete -c sshd-openpgp-auth -n "__fish_use_subcommand" -s V -l version -d 'Print version'
complete -c sshd-openpgp-auth -n "__fish_use_subcommand" -f -a "add" -d 'Add public SSH host keys as authentication subkeys to an OpenPGP certificate'
complete -c sshd-openpgp-auth -n "__fish_use_subcommand" -f -a "export" -d 'Export OpenPGP certificates to Web Key Directory (WKD)'
complete -c sshd-openpgp-auth -n "__fish_use_subcommand" -f -a "extend" -d 'Extend the expiration period of an OpenPGP certificate'
complete -c sshd-openpgp-auth -n "__fish_use_subcommand" -f -a "init" -d 'Initialize a new OpenPGP certificate, that serves as trust anchor for public SSH host keys'
complete -c sshd-openpgp-auth -n "__fish_use_subcommand" -f -a "list" -d 'List local OpenPGP certificates that serve as trust anchor'
complete -c sshd-openpgp-auth -n "__fish_use_subcommand" -f -a "revoke" -d 'Revoke subkeys of an OpenPGP certificate'
complete -c sshd-openpgp-auth -n "__fish_use_subcommand" -f -a "proof" -d 'Manages Keyoxide proofs'
complete -c sshd-openpgp-auth -n "__fish_use_subcommand" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sshd-openpgp-auth -n "__fish_seen_subcommand_from add" -s f -l fingerprint -d 'An OpenPGP fingerprint to identify a specific certificate' -r
complete -c sshd-openpgp-auth -n "__fish_seen_subcommand_from add" -s o -l openpgp-dir -d 'A custom directory in which to look for OpenPGP certificates (defaults to "/var/lib/sshd-openpgp-auth/")' -r -F
complete -c sshd-openpgp-auth -n "__fish_seen_subcommand_from add" -s S -l ssh-dir -d 'A custom directory in which to look for SSH public keys (defaults to "/etc/ssh/")' -r -F
complete -c sshd-openpgp-auth -n "__fish_seen_subcommand_from add" -s t -l time -d 'A custom reference time formatted as an RFC3339 string (defaults to now)' -r
complete -c sshd-openpgp-auth -n "__fish_seen_subcommand_from add" -s k -l known-hosts -d 'Read the SSH public keys in known_hosts format from stdin instead of from a directory'
complete -c sshd-openpgp-auth -n "__fish_seen_subcommand_from add" -s s -l stdout -d 'Output the OpenPGP certificate to stdout instead of a file'
complete -c sshd-openpgp-auth -n "__fish_seen_subcommand_from add" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sshd-openpgp-auth -n "__fish_seen_subcommand_from export" -s o -l openpgp-dir -d 'A custom directory in which to look for OpenPGP certificates (defaults to "/var/lib/sshd-openpgp-auth/")' -r -F
complete -c sshd-openpgp-auth -n "__fish_seen_subcommand_from export" -s O -l output-dir -d 'A custom output directory (defaults to "wkd")' -r -F
complete -c sshd-openpgp-auth -n "__fish_seen_subcommand_from export" -s w -l wkd-type -d 'A custom WKD type to export to (defaults to "advanced")' -r
complete -c sshd-openpgp-auth -n "__fish_seen_subcommand_from export" -s t -l time -d 'A custom reference time formatted as an RFC3339 string (defaults to now)' -r
complete -c sshd-openpgp-auth -n "__fish_seen_subcommand_from export" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sshd-openpgp-auth -n "__fish_seen_subcommand_from extend" -s e -l expiry -d 'The expiry period in days from reference time (defaults to 365)' -r
complete -c sshd-openpgp-auth -n "__fish_seen_subcommand_from extend" -s f -l fingerprint -d 'An OpenPGP fingerprint to identify a specific certificate' -r
complete -c sshd-openpgp-auth -n "__fish_seen_subcommand_from extend" -s o -l openpgp-dir -d 'A custom directory in which to look for OpenPGP certificates (defaults to "/var/lib/sshd-openpgp-auth/")' -r -F
complete -c sshd-openpgp-auth -n "__fish_seen_subcommand_from extend" -s T -l threshold -d 'A custom threshold in days from reference time, after which expiry period is extended (defaults to 250)' -r
complete -c sshd-openpgp-auth -n "__fish_seen_subcommand_from extend" -s t -l time -d 'A custom reference time formatted as an RFC3339 string (defaults to now)' -r
complete -c sshd-openpgp-auth -n "__fish_seen_subcommand_from extend" -s s -l stdout -d 'Output the OpenPGP certificate to stdout instead of a file'
complete -c sshd-openpgp-auth -n "__fish_seen_subcommand_from extend" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sshd-openpgp-auth -n "__fish_seen_subcommand_from init" -s e -l expiry -d 'The expiry period in days from reference time (defaults to 365)' -r
complete -c sshd-openpgp-auth -n "__fish_seen_subcommand_from init" -s o -l openpgp-dir -d 'A custom directory into which the OpenPGP certificate is written (defaults to "/var/lib/sshd-openpgp-auth/")' -r -F
complete -c sshd-openpgp-auth -n "__fish_seen_subcommand_from init" -s t -l time -d 'A custom reference time formatted as an RFC3339 string (defaults to now)' -r
complete -c sshd-openpgp-auth -n "__fish_seen_subcommand_from init" -s s -l stdout -d 'Output the OpenPGP certificate to stdout instead of a file'
complete -c sshd-openpgp-auth -n "__fish_seen_subcommand_from init" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sshd-openpgp-auth -n "__fish_seen_subcommand_from list" -s f -l filter -d 'A hostname, as fully qualified domain name (FQDN), by which to filter' -r
complete -c sshd-openpgp-auth -n "__fish_seen_subcommand_from list" -s o -l openpgp-dir -d 'A custom directory in which to look for OpenPGP certificates (defaults to "/var/lib/sshd-openpgp-auth/")' -r -F
complete -c sshd-openpgp-auth -n "__fish_seen_subcommand_from list" -s t -l time -d 'A custom reference time formatted as an RFC3339 string (defaults to now)' -r
complete -c sshd-openpgp-auth -n "__fish_seen_subcommand_from list" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sshd-openpgp-auth -n "__fish_seen_subcommand_from revoke" -s f -l fingerprint -d 'An OpenPGP fingerprint to identify a specific certificate' -r
complete -c sshd-openpgp-auth -n "__fish_seen_subcommand_from revoke" -s m -l message -d 'An optional message for the revocation' -r
complete -c sshd-openpgp-auth -n "__fish_seen_subcommand_from revoke" -s o -l openpgp-dir -d 'A custom directory in which to look for OpenPGP certificates (defaults to "/var/lib/sshd-openpgp-auth/")' -r -F
complete -c sshd-openpgp-auth -n "__fish_seen_subcommand_from revoke" -s r -l reason -d 'A custom revocation reason (defaults to "superseded")' -r
complete -c sshd-openpgp-auth -n "__fish_seen_subcommand_from revoke" -s S -l subkey-fingerprint -d 'An OpenPGP fingerprint to identify a specific subkey' -r
complete -c sshd-openpgp-auth -n "__fish_seen_subcommand_from revoke" -s t -l time -d 'A custom reference time formatted as an RFC3339 string (defaults to now)' -r
complete -c sshd-openpgp-auth -n "__fish_seen_subcommand_from revoke" -s a -l all -d 'Revoke all subkeys of the chosen OpenPGP certificate'
complete -c sshd-openpgp-auth -n "__fish_seen_subcommand_from revoke" -s s -l stdout -d 'Output the OpenPGP certificate to stdout instead of a file'
complete -c sshd-openpgp-auth -n "__fish_seen_subcommand_from revoke" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sshd-openpgp-auth -n "__fish_seen_subcommand_from proof; and not __fish_seen_subcommand_from dns; and not __fish_seen_subcommand_from help" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sshd-openpgp-auth -n "__fish_seen_subcommand_from proof; and not __fish_seen_subcommand_from dns; and not __fish_seen_subcommand_from help" -f -a "dns" -d 'Manages DNS proofs'
complete -c sshd-openpgp-auth -n "__fish_seen_subcommand_from proof; and not __fish_seen_subcommand_from dns; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sshd-openpgp-auth -n "__fish_seen_subcommand_from proof; and __fish_seen_subcommand_from dns; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from help" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sshd-openpgp-auth -n "__fish_seen_subcommand_from proof; and __fish_seen_subcommand_from dns; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from help" -f -a "add" -d 'Add DNS proof to an OpenPGP certificate'
complete -c sshd-openpgp-auth -n "__fish_seen_subcommand_from proof; and __fish_seen_subcommand_from dns; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sshd-openpgp-auth -n "__fish_seen_subcommand_from proof; and __fish_seen_subcommand_from dns; and __fish_seen_subcommand_from add" -s o -l openpgp-dir -d 'A custom directory in which to look for OpenPGP certificates (defaults to "/var/lib/sshd-openpgp-auth/")' -r -F
complete -c sshd-openpgp-auth -n "__fish_seen_subcommand_from proof; and __fish_seen_subcommand_from dns; and __fish_seen_subcommand_from add" -s f -l fingerprint -d 'An OpenPGP fingerprint to identify a specific certificate' -r
complete -c sshd-openpgp-auth -n "__fish_seen_subcommand_from proof; and __fish_seen_subcommand_from dns; and __fish_seen_subcommand_from add" -s t -l time -d 'A custom reference time formatted as an RFC3339 string (defaults to now)' -r
complete -c sshd-openpgp-auth -n "__fish_seen_subcommand_from proof; and __fish_seen_subcommand_from dns; and __fish_seen_subcommand_from add" -s s -l stdout -d 'Output the OpenPGP certificate to stdout instead of a file'
complete -c sshd-openpgp-auth -n "__fish_seen_subcommand_from proof; and __fish_seen_subcommand_from dns; and __fish_seen_subcommand_from add" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sshd-openpgp-auth -n "__fish_seen_subcommand_from proof; and __fish_seen_subcommand_from dns; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from help" -f -a "add" -d 'Add DNS proof to an OpenPGP certificate'
complete -c sshd-openpgp-auth -n "__fish_seen_subcommand_from proof; and __fish_seen_subcommand_from dns; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sshd-openpgp-auth -n "__fish_seen_subcommand_from proof; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from dns; and not __fish_seen_subcommand_from help" -f -a "dns" -d 'Manages DNS proofs'
complete -c sshd-openpgp-auth -n "__fish_seen_subcommand_from proof; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from dns; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sshd-openpgp-auth -n "__fish_seen_subcommand_from proof; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from dns; and not __fish_seen_subcommand_from add" -f -a "add" -d 'Add DNS proof to an OpenPGP certificate'
complete -c sshd-openpgp-auth -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from export; and not __fish_seen_subcommand_from extend; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from proof; and not __fish_seen_subcommand_from help" -f -a "add" -d 'Add public SSH host keys as authentication subkeys to an OpenPGP certificate'
complete -c sshd-openpgp-auth -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from export; and not __fish_seen_subcommand_from extend; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from proof; and not __fish_seen_subcommand_from help" -f -a "export" -d 'Export OpenPGP certificates to Web Key Directory (WKD)'
complete -c sshd-openpgp-auth -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from export; and not __fish_seen_subcommand_from extend; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from proof; and not __fish_seen_subcommand_from help" -f -a "extend" -d 'Extend the expiration period of an OpenPGP certificate'
complete -c sshd-openpgp-auth -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from export; and not __fish_seen_subcommand_from extend; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from proof; and not __fish_seen_subcommand_from help" -f -a "init" -d 'Initialize a new OpenPGP certificate, that serves as trust anchor for public SSH host keys'
complete -c sshd-openpgp-auth -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from export; and not __fish_seen_subcommand_from extend; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from proof; and not __fish_seen_subcommand_from help" -f -a "list" -d 'List local OpenPGP certificates that serve as trust anchor'
complete -c sshd-openpgp-auth -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from export; and not __fish_seen_subcommand_from extend; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from proof; and not __fish_seen_subcommand_from help" -f -a "revoke" -d 'Revoke subkeys of an OpenPGP certificate'
complete -c sshd-openpgp-auth -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from export; and not __fish_seen_subcommand_from extend; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from proof; and not __fish_seen_subcommand_from help" -f -a "proof" -d 'Manages Keyoxide proofs'
complete -c sshd-openpgp-auth -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from export; and not __fish_seen_subcommand_from extend; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from proof; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sshd-openpgp-auth -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from proof; and not __fish_seen_subcommand_from dns" -f -a "dns" -d 'Manages DNS proofs'
complete -c sshd-openpgp-auth -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from proof; and __fish_seen_subcommand_from dns; and not __fish_seen_subcommand_from add" -f -a "add" -d 'Add DNS proof to an OpenPGP certificate'
