import { EndpointParameterInstructions } from "@smithy/middleware-endpoint";
import { Command as $Command } from "@smithy/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@smithy/types";
import { CloudFormationClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../CloudFormationClient";
import { DescribeStackDriftDetectionStatusInput, DescribeStackDriftDetectionStatusOutput } from "../models/models_0";
/**
 * @public
 */
export { __MetadataBearer, $Command };
/**
 * @public
 *
 * The input for {@link DescribeStackDriftDetectionStatusCommand}.
 */
export interface DescribeStackDriftDetectionStatusCommandInput extends DescribeStackDriftDetectionStatusInput {
}
/**
 * @public
 *
 * The output of {@link DescribeStackDriftDetectionStatusCommand}.
 */
export interface DescribeStackDriftDetectionStatusCommandOutput extends DescribeStackDriftDetectionStatusOutput, __MetadataBearer {
}
/**
 * @public
 * <p>Returns information about a stack drift detection operation. A stack drift detection operation detects whether a
 *    stack's actual configuration differs, or has <i>drifted</i>, from its expected configuration, as
 *    defined in the stack template and any values specified as template parameters. A stack is considered to have drifted
 *    if one or more of its resources have drifted. For more information about stack and resource drift, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detecting Unregulated
 *     Configuration Changes to Stacks and Resources</a>.</p>
 *          <p>Use <a>DetectStackDrift</a> to initiate a stack drift detection operation.
 *     <code>DetectStackDrift</code> returns a <code>StackDriftDetectionId</code> you can use to monitor the progress of
 *    the operation using <code>DescribeStackDriftDetectionStatus</code>. Once the drift detection operation has completed,
 *    use <a>DescribeStackResourceDrifts</a> to return drift information about the stack and its
 *    resources.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { CloudFormationClient, DescribeStackDriftDetectionStatusCommand } from "@aws-sdk/client-cloudformation"; // ES Modules import
 * // const { CloudFormationClient, DescribeStackDriftDetectionStatusCommand } = require("@aws-sdk/client-cloudformation"); // CommonJS import
 * const client = new CloudFormationClient(config);
 * const input = { // DescribeStackDriftDetectionStatusInput
 *   StackDriftDetectionId: "STRING_VALUE", // required
 * };
 * const command = new DescribeStackDriftDetectionStatusCommand(input);
 * const response = await client.send(command);
 * // { // DescribeStackDriftDetectionStatusOutput
 * //   StackId: "STRING_VALUE", // required
 * //   StackDriftDetectionId: "STRING_VALUE", // required
 * //   StackDriftStatus: "DRIFTED" || "IN_SYNC" || "UNKNOWN" || "NOT_CHECKED",
 * //   DetectionStatus: "DETECTION_IN_PROGRESS" || "DETECTION_FAILED" || "DETECTION_COMPLETE", // required
 * //   DetectionStatusReason: "STRING_VALUE",
 * //   DriftedStackResourceCount: Number("int"),
 * //   Timestamp: new Date("TIMESTAMP"), // required
 * // };
 *
 * ```
 *
 * @param DescribeStackDriftDetectionStatusCommandInput - {@link DescribeStackDriftDetectionStatusCommandInput}
 * @returns {@link DescribeStackDriftDetectionStatusCommandOutput}
 * @see {@link DescribeStackDriftDetectionStatusCommandInput} for command's `input` shape.
 * @see {@link DescribeStackDriftDetectionStatusCommandOutput} for command's `response` shape.
 * @see {@link CloudFormationClientResolvedConfig | config} for CloudFormationClient's `config` shape.
 *
 * @throws {@link CloudFormationServiceException}
 * <p>Base exception class for all service exceptions from CloudFormation service.</p>
 *
 */
export declare class DescribeStackDriftDetectionStatusCommand extends $Command<DescribeStackDriftDetectionStatusCommandInput, DescribeStackDriftDetectionStatusCommandOutput, CloudFormationClientResolvedConfig> {
    readonly input: DescribeStackDriftDetectionStatusCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    /**
     * @public
     */
    constructor(input: DescribeStackDriftDetectionStatusCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: CloudFormationClientResolvedConfig, options?: __HttpHandlerOptions): Handler<DescribeStackDriftDetectionStatusCommandInput, DescribeStackDriftDetectionStatusCommandOutput>;
    /**
     * @internal
     */
    private serialize;
    /**
     * @internal
     */
    private deserialize;
}
