/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.update;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import org.protege.editor.core.ui.util.LinkLabel;
import org.protege.editor.core.ui.util.NativeBrowserLauncher;
import org.protege.editor.core.update.PluginInfo;
import org.protege.editor.core.update.PluginManager;
import org.protege.editor.core.update.PluginTable;

public class PluginPanel
extends JPanel {
    private final JLabel authorLabel = new JLabel("");
    private LinkLabel licenseLabel;
    private final JEditorPane readmePane = new JEditorPane();
    private JScrollPane readmeScroller;
    private Map<PluginInfo, ContentMimePair> updateInfoReadmeMap = new HashMap<PluginInfo, ContentMimePair>();
    private PluginTable pluginTable;
    private JCheckBox alwaysShow;

    public PluginPanel(List<PluginInfo> pluginInfoList) {
        this.setPreferredSize(new Dimension(600, 600));
        this.setLayout(new BorderLayout(2, 2));
        JSplitPane sp = new JSplitPane(0);
        sp.setBorder(new EmptyBorder(6, 6, 6, 6));
        sp.setResizeWeight(0.5);
        this.pluginTable = new PluginTable(pluginInfoList);
        this.pluginTable.addListSelectionListener(e -> {
            PluginInfo info = this.pluginTable.getCurrentUpdateInfo();
            this.updateInfoPanel(info);
        });
        sp.setTopComponent(new JScrollPane(this.pluginTable));
        sp.setBottomComponent(this.createInfoBox());
        this.add((Component)sp, "Center");
        this.alwaysShow = new JCheckBox("Always check for updates on startup.", PluginManager.getInstance().isAutoUpdateEnabled());
        this.alwaysShow.addActionListener(event -> PluginManager.getInstance().setAutoUpdateEnabled(this.alwaysShow.isSelected()));
        this.alwaysShow.setAlignmentX(0.0f);
        this.add((Component)this.alwaysShow, "South");
    }

    private Component createInfoBox() {
        Box infoBox = new Box(3);
        infoBox.add(Box.createRigidArea(new Dimension(0, 7)));
        infoBox.add(this.createAuthorPanel());
        infoBox.add(Box.createRigidArea(new Dimension(0, 7)));
        infoBox.add(this.createLicensePanel());
        infoBox.add(Box.createRigidArea(new Dimension(0, 7)));
        infoBox.add(this.createDocPanel());
        return infoBox;
    }

    private Component createAuthorPanel() {
        Box box = new Box(2);
        JLabel label = new JLabel("Author: ");
        Font font = label.getFont().deriveFont(1);
        label.setFont(font);
        label.setAlignmentX(0.0f);
        box.add(label);
        this.authorLabel.setFont(font);
        box.add(this.authorLabel);
        box.add(Box.createHorizontalGlue());
        return box;
    }

    private Component createLicensePanel() {
        Box box = new Box(2);
        JLabel label = new JLabel("License: ");
        Font font = label.getFont().deriveFont(1);
        label.setFont(font);
        label.setAlignmentX(0.0f);
        box.add(label);
        this.licenseLabel = new LinkLabel("", event -> {
            try {
                URL url = new URL(this.licenseLabel.getText());
                NativeBrowserLauncher.openURL(url.toString());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        });
        this.licenseLabel.setFont(font);
        box.add(this.licenseLabel);
        box.add(Box.createHorizontalGlue());
        return box;
    }

    private Component createDocPanel() {
        this.createTextPanel();
        this.readmeScroller = new JScrollPane(this.readmePane, 22, 31);
        this.readmeScroller.setOpaque(false);
        return this.readmeScroller;
    }

    private void createTextPanel() {
        JEditorPane pane = new JEditorPane();
        pane.setBorder(new EmptyBorder(12, 12, 12, 12));
        pane.setPreferredSize(new Dimension(300, 200));
        pane.setEditable(false);
        pane.addHyperlinkListener(event -> {
            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED && event.getURL() != null) {
                NativeBrowserLauncher.openURL(event.getURL().toString());
            }
        });
    }

    private void updateInfoPanel(PluginInfo info) {
        this.updateDocPanel(new ContentMimePair("", ""), this.readmePane, this.readmeScroller);
        if (info != null) {
            this.authorLabel.setText(info.getAuthor().orElse(""));
            this.licenseLabel.setText(info.getLicense().orElse(""));
            ContentMimePair readme = this.updateInfoReadmeMap.get(info);
            if (readme != null) {
                this.updateDocPanel(readme, this.readmePane, this.readmeScroller);
            } else if (info.getReadmeURI().isPresent()) {
                Runnable loadContent = () -> {
                    ContentMimePair readme1 = this.getContent(info.getReadmeURI().get());
                    this.updateInfoReadmeMap.put(info, readme1);
                    SwingUtilities.invokeLater(() -> this.updateDocPanel(readme1, this.readmePane, this.readmeScroller));
                };
                Thread t = new Thread(loadContent, "Load plugin info");
                t.setPriority(1);
                t.start();
            }
        } else {
            this.authorLabel.setText("");
            this.licenseLabel.setText("");
        }
    }

    private ContentMimePair getContent(URL url) {
        if (url == null) {
            return new ContentMimePair("No info provided", "text/plain");
        }
        try {
            String line;
            String mimeType = url.openConnection().getContentType();
            BufferedReader reader = new BufferedReader(new InputStreamReader(new BufferedInputStream(url.openStream())));
            StringBuilder readmeBuilder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                readmeBuilder.append(line);
                readmeBuilder.append("\n");
            }
            if (readmeBuilder.toString().contains("<html")) {
                mimeType = "text/html";
            }
            reader.close();
            return new ContentMimePair(readmeBuilder.toString(), mimeType);
        }
        catch (IOException e) {
            return new ContentMimePair("Problem obtaining details: " + e.getMessage(), "text/plain");
        }
    }

    private void updateDocPanel(ContentMimePair content, JEditorPane textEditor, JScrollPane scroller) {
        textEditor.setContentType(content.mimeType);
        textEditor.setText(content.content);
        SwingUtilities.invokeLater(() -> {
            scroller.getViewport().setViewPosition(new Point(0, 0));
            Document document = this.readmePane.getDocument();
            if (document instanceof HTMLDocument) {
                HTMLDocument htmlDocument = (HTMLDocument)document;
                StyleSheet styleSheet = htmlDocument.getStyleSheet();
                styleSheet.addRule("body {font-family: Helvetica Neue, Helvetica, Arial, Sans-Serif; font-weight: 300; font-size: 10px; color: #808080; padding-left: 10px; padding-right: 10px; padding-top: 2px; }");
            }
        });
    }

    public List<PluginInfo> getPluginsToInstall() {
        return this.pluginTable.getSelectedUpdateInfo();
    }

    public static List<PluginInfo> showDialog(List<PluginInfo> pluginInfoList, Component parent) {
        PluginPanel panel = new PluginPanel(pluginInfoList);
        String installOption = "Install";
        String notNowOption = "Not now";
        Object[] options = new String[]{"Install", "Not now"};
        JOptionPane optionPane = new JOptionPane(panel, -1, 2, null, options, options[0]);
        JDialog dlg = optionPane.createDialog(parent, "Automatic Update");
        dlg.setModal(true);
        dlg.setResizable(true);
        dlg.setVisible(true);
        if ("Install".equals(optionPane.getValue())) {
            return panel.getPluginsToInstall();
        }
        return Collections.emptyList();
    }

    class ContentMimePair {
        public String content;
        public String mimeType;

        ContentMimePair(String content, String mimeType) {
            this.content = content;
            this.mimeType = mimeType;
        }
    }
}

