/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.connector;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.io.stream.BytesStreamOutput;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.ml.common.AccessMode;
import org.opensearch.ml.common.connector.Connector;
import org.opensearch.ml.common.connector.ConnectorAction;
import org.opensearch.ml.common.connector.HttpConnector;

@org.opensearch.ml.common.annotation.Connector(value="aws_sigv4")
public class AwsConnector
extends HttpConnector {
    @Generated
    private static final Logger log = LogManager.getLogger(AwsConnector.class);

    public AwsConnector(String name, String description, String version, String protocol, Map<String, String> parameters, Map<String, String> credential, List<ConnectorAction> actions, List<String> backendRoles, AccessMode accessMode, User owner) {
        super(name, description, version, protocol, parameters, credential, actions, backendRoles, accessMode, owner);
        this.validate();
    }

    public AwsConnector(String protocol, XContentParser parser) throws IOException {
        super(protocol, parser);
        this.validate();
    }

    public AwsConnector(StreamInput input) throws IOException {
        super(input);
        this.validate();
    }

    private void validate() {
        if (this.credential == null || !this.credential.containsKey("access_key") || !this.credential.containsKey("secret_key")) {
            throw new IllegalArgumentException("Missing credential");
        }
        if (!(this.credential != null && this.credential.containsKey("service_name") || this.parameters != null && this.parameters.containsKey("service_name"))) {
            throw new IllegalArgumentException("Missing service name");
        }
        if (!(this.credential != null && this.credential.containsKey("region") || this.parameters != null && this.parameters.containsKey("region"))) {
            throw new IllegalArgumentException("Missing region");
        }
    }

    @Override
    public Connector cloneConnector() {
        AwsConnector awsConnector;
        BytesStreamOutput bytesStreamOutput = new BytesStreamOutput();
        try {
            this.writeTo((StreamOutput)bytesStreamOutput);
            StreamInput streamInput = bytesStreamOutput.bytes().streamInput();
            awsConnector = new AwsConnector(streamInput);
        }
        catch (Throwable throwable) {
            try {
                try {
                    bytesStreamOutput.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        bytesStreamOutput.close();
        return awsConnector;
    }

    public String getAccessKey() {
        return (String)this.decryptedCredential.get("access_key");
    }

    public String getSecretKey() {
        return (String)this.decryptedCredential.get("secret_key");
    }

    public String getSessionToken() {
        return (String)this.decryptedCredential.get("session_token");
    }

    public String getServiceName() {
        if (this.parameters == null) {
            return (String)this.decryptedCredential.get("service_name");
        }
        return Optional.ofNullable((String)this.parameters.get("service_name")).orElse((String)this.decryptedCredential.get("service_name"));
    }

    public String getRegion() {
        if (this.parameters == null) {
            return (String)this.decryptedCredential.get("region");
        }
        return Optional.ofNullable((String)this.parameters.get("region")).orElse((String)this.decryptedCredential.get("region"));
    }

    @Generated
    public static AwsConnectorBuilder awsConnectorBuilder() {
        return new AwsConnectorBuilder();
    }

    @Generated
    public AwsConnector() {
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AwsConnector)) {
            return false;
        }
        AwsConnector other = (AwsConnector)o;
        return other.canEqual(this);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AwsConnector;
    }

    @Override
    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    public static class AwsConnectorBuilder {
        @Generated
        private String name;
        @Generated
        private String description;
        @Generated
        private String version;
        @Generated
        private String protocol;
        @Generated
        private Map<String, String> parameters;
        @Generated
        private Map<String, String> credential;
        @Generated
        private List<ConnectorAction> actions;
        @Generated
        private List<String> backendRoles;
        @Generated
        private AccessMode accessMode;
        @Generated
        private User owner;

        @Generated
        AwsConnectorBuilder() {
        }

        @Generated
        public AwsConnectorBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public AwsConnectorBuilder description(String description) {
            this.description = description;
            return this;
        }

        @Generated
        public AwsConnectorBuilder version(String version) {
            this.version = version;
            return this;
        }

        @Generated
        public AwsConnectorBuilder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Generated
        public AwsConnectorBuilder parameters(Map<String, String> parameters) {
            this.parameters = parameters;
            return this;
        }

        @Generated
        public AwsConnectorBuilder credential(Map<String, String> credential) {
            this.credential = credential;
            return this;
        }

        @Generated
        public AwsConnectorBuilder actions(List<ConnectorAction> actions) {
            this.actions = actions;
            return this;
        }

        @Generated
        public AwsConnectorBuilder backendRoles(List<String> backendRoles) {
            this.backendRoles = backendRoles;
            return this;
        }

        @Generated
        public AwsConnectorBuilder accessMode(AccessMode accessMode) {
            this.accessMode = accessMode;
            return this;
        }

        @Generated
        public AwsConnectorBuilder owner(User owner) {
            this.owner = owner;
            return this;
        }

        @Generated
        public AwsConnector build() {
            return new AwsConnector(this.name, this.description, this.version, this.protocol, this.parameters, this.credential, this.actions, this.backendRoles, this.accessMode, this.owner);
        }

        @Generated
        public String toString() {
            return "AwsConnector.AwsConnectorBuilder(name=" + this.name + ", description=" + this.description + ", version=" + this.version + ", protocol=" + this.protocol + ", parameters=" + this.parameters + ", credential=" + this.credential + ", actions=" + this.actions + ", backendRoles=" + this.backendRoles + ", accessMode=" + this.accessMode + ", owner=" + this.owner + ")";
        }
    }
}

