/*
 * Decompiled with CFR 0.152.
 */
package com.nulabinc.zxcvbn.matchers;

import com.nulabinc.zxcvbn.io.Resource;
import com.nulabinc.zxcvbn.matchers.Dictionary;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class DictionaryLoader {
    private final String name;
    private final Resource resource;

    public DictionaryLoader(String name, Resource resource) {
        this.name = name;
        this.resource = resource;
    }

    public Dictionary load() throws IOException {
        ArrayList<String> words = new ArrayList<String>();
        try (InputStream inputStream = this.resource.getInputStream();
             InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
             BufferedReader br = new BufferedReader(inputStreamReader);){
            String line;
            while ((line = br.readLine()) != null) {
                words.add(line);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error while reading " + this.name);
        }
        return new Dictionary(this.name, words);
    }
}

