/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.securityconf.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.security.filter.SecurityRequest;
import org.opensearch.security.filter.SecurityResponse;
import org.opensearch.security.securityconf.impl.HttpRequestMethods;

public class AllowlistingSettings {
    private boolean enabled;
    private Map<String, List<HttpRequestMethods>> requests;

    public AllowlistingSettings() {
        this.enabled = false;
        this.requests = Collections.emptyMap();
    }

    public AllowlistingSettings(AllowlistingSettings allowlistingSettings) {
        this.enabled = allowlistingSettings.getEnabled();
        this.requests = allowlistingSettings.getRequests();
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Map<String, List<HttpRequestMethods>> getRequests() {
        return this.requests == null ? Collections.emptyMap() : this.requests;
    }

    public void setRequests(Map<String, List<HttpRequestMethods>> requests) {
        this.requests = requests;
    }

    public String toString() {
        return "AllowlistingSetting [enabled=" + this.enabled + ", requests=" + this.requests + "]";
    }

    private boolean requestIsAllowlisted(SecurityRequest request) {
        String path = request.path();
        String pathWithoutTrailingSlash = path.endsWith("/") ? path.substring(0, path.length() - 1) : path;
        String pathWithTrailingSlash = pathWithoutTrailingSlash + "/";
        if (this.requests.containsKey(pathWithoutTrailingSlash) && this.requests.get(pathWithoutTrailingSlash).contains((Object)HttpRequestMethods.valueOf(request.method().toString()))) {
            return true;
        }
        return this.requests.containsKey(pathWithTrailingSlash) && this.requests.get(pathWithTrailingSlash).contains((Object)HttpRequestMethods.valueOf(request.method().toString()));
    }

    public Optional<SecurityResponse> checkRequestIsAllowed(SecurityRequest request) {
        if (this.enabled && !this.requestIsAllowlisted(request)) {
            return Optional.of(new SecurityResponse(403, SecurityResponse.CONTENT_TYPE_APP_JSON, this.generateFailureMessage(request)));
        }
        return Optional.empty();
    }

    protected String getVerb() {
        return "allowlisted";
    }

    protected String generateFailureMessage(SecurityRequest request) {
        try {
            return XContentFactory.jsonBuilder().startObject().field("error", request.method() + " " + request.path() + " API not " + this.getVerb()).field("status", (Object)RestStatus.FORBIDDEN).endObject().toString();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }
}

