/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.reportsscheduler.model;

import java.io.IOException;
import java.io.OutputStream;
import java.time.Instant;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.reportsscheduler.metrics.Metrics;
import org.opensearch.reportsscheduler.model.ReportDefinitionDetails;
import org.opensearch.reportsscheduler.model.ReportInstance;
import org.opensearch.reportsscheduler.model.RestTag;
import org.opensearch.reportsscheduler.util.HelpersKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 )2\u00020\u00012\u00020\u0002:\u0001)BA\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\rB\u000f\b\u0016\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010B\u000f\b\u0016\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\b\u0002\u0010 \u001a\u00020!J\u001c\u0010\u001e\u001a\u00020\u001f2\b\u0010\"\u001a\u0004\u0018\u00010\u001f2\b\u0010 \u001a\u0004\u0018\u00010!H\u0016J\n\u0010#\u001a\u0004\u0018\u00010$H\u0016J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u0013\u0010\f\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0018\u00a8\u0006*"}, d2={"Lorg/opensearch/reportsscheduler/model/InContextReportCreateRequest;", "Lorg/opensearch/action/ActionRequest;", "Lorg/opensearch/core/xcontent/ToXContentObject;", "beginTime", "Ljava/time/Instant;", "endTime", "reportDefinitionDetails", "Lorg/opensearch/reportsscheduler/model/ReportDefinitionDetails;", "status", "Lorg/opensearch/reportsscheduler/model/ReportInstance$Status;", "statusText", "", "inContextDownloadUrlPath", "(Ljava/time/Instant;Ljava/time/Instant;Lorg/opensearch/reportsscheduler/model/ReportDefinitionDetails;Lorg/opensearch/reportsscheduler/model/ReportInstance$Status;Ljava/lang/String;Ljava/lang/String;)V", "input", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "parser", "Lorg/opensearch/core/xcontent/XContentParser;", "(Lorg/opensearch/core/xcontent/XContentParser;)V", "getBeginTime", "()Ljava/time/Instant;", "getEndTime", "getInContextDownloadUrlPath", "()Ljava/lang/String;", "getReportDefinitionDetails", "()Lorg/opensearch/reportsscheduler/model/ReportDefinitionDetails;", "getStatus", "()Lorg/opensearch/reportsscheduler/model/ReportInstance$Status;", "getStatusText", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "builder", "validate", "Lorg/opensearch/action/ActionRequestValidationException;", "writeTo", "", "output", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "Companion", "opensearch-reports-scheduler"})
public final class InContextReportCreateRequest
extends ActionRequest
implements ToXContentObject {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Instant beginTime;
    @NotNull
    private final Instant endTime;
    @Nullable
    private final ReportDefinitionDetails reportDefinitionDetails;
    @NotNull
    private final ReportInstance.Status status;
    @Nullable
    private final String statusText;
    @Nullable
    private final String inContextDownloadUrlPath;
    @NotNull
    private static final Lazy<Logger> log$delegate = HelpersKt.logger(InContextReportCreateRequest.class);

    @NotNull
    public final Instant getBeginTime() {
        return this.beginTime;
    }

    @NotNull
    public final Instant getEndTime() {
        return this.endTime;
    }

    @Nullable
    public final ReportDefinitionDetails getReportDefinitionDetails() {
        return this.reportDefinitionDetails;
    }

    @NotNull
    public final ReportInstance.Status getStatus() {
        return this.status;
    }

    @Nullable
    public final String getStatusText() {
        return this.statusText;
    }

    @Nullable
    public final String getInContextDownloadUrlPath() {
        return this.inContextDownloadUrlPath;
    }

    public InContextReportCreateRequest(@NotNull Instant beginTime, @NotNull Instant endTime, @Nullable ReportDefinitionDetails reportDefinitionDetails, @NotNull ReportInstance.Status status, @Nullable String statusText, @Nullable String inContextDownloadUrlPath) {
        Intrinsics.checkNotNullParameter((Object)beginTime, (String)"beginTime");
        Intrinsics.checkNotNullParameter((Object)endTime, (String)"endTime");
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
        this.beginTime = beginTime;
        this.endTime = endTime;
        this.reportDefinitionDetails = reportDefinitionDetails;
        this.status = status;
        this.statusText = statusText;
        this.inContextDownloadUrlPath = inContextDownloadUrlPath;
    }

    public /* synthetic */ InContextReportCreateRequest(Instant instant, Instant instant2, ReportDefinitionDetails reportDefinitionDetails, ReportInstance.Status status, String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            string = null;
        }
        if ((n & 0x20) != 0) {
            string2 = null;
        }
        this(instant, instant2, reportDefinitionDetails, status, string, string2);
    }

    public InContextReportCreateRequest(@NotNull StreamInput input) throws IOException {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this(HelpersKt.createJsonParser(input));
    }

    public InContextReportCreateRequest(@NotNull XContentParser parser) {
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        Instant beginTime = null;
        Instant endTime = null;
        ReportDefinitionDetails reportDefinitionDetails = null;
        ReportInstance.Status status = null;
        String statusText = null;
        String inContextDownloadUrlPath = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block16: while (XContentParser.Token.END_OBJECT != parser.nextToken()) {
            String fieldName;
            block26: {
                fieldName = parser.currentName();
                parser.nextToken();
                String string = fieldName;
                if (string == null) break block26;
                int n = -1;
                switch (string.hashCode()) {
                    case 121872994: {
                        if (string.equals("inContextDownloadUrlPath")) {
                            n = 1;
                        }
                        break;
                    }
                    case -207003812: {
                        if (string.equals("beginTimeMs")) {
                            n = 2;
                        }
                        break;
                    }
                    case 248004671: {
                        if (string.equals("statusText")) {
                            n = 3;
                        }
                        break;
                    }
                    case -1906132325: {
                        if (string.equals("reportDefinitionDetails")) {
                            n = 4;
                        }
                        break;
                    }
                    case 1627521550: {
                        if (string.equals("endTimeMs")) {
                            n = 5;
                        }
                        break;
                    }
                    case -892481550: {
                        if (string.equals("status")) {
                            n = 6;
                        }
                        break;
                    }
                }
                switch (n) {
                    case 2: {
                        beginTime = Instant.ofEpochMilli(parser.longValue());
                        continue block16;
                    }
                    case 5: {
                        endTime = Instant.ofEpochMilli(parser.longValue());
                        continue block16;
                    }
                    case 4: {
                        reportDefinitionDetails = ReportDefinitionDetails.Companion.parse$default(ReportDefinitionDetails.Companion, parser, null, 2, null);
                        continue block16;
                    }
                    case 6: {
                        String string2 = parser.text();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"parser.text()");
                        status = ReportInstance.Status.valueOf(string2);
                        continue block16;
                    }
                    case 3: {
                        statusText = parser.text();
                        continue block16;
                    }
                    case 1: {
                        inContextDownloadUrlPath = parser.text();
                        continue block16;
                    }
                }
            }
            parser.skipChildren();
            InContextReportCreateRequest.Companion.getLog().info("reports:InContextReportCreateRequest Skipping Unknown field " + fieldName);
        }
        if (beginTime == null) {
            InContextReportCreateRequest $this$_init__u24lambda_u240 = this;
            boolean bl = false;
            Metrics.REPORT_FROM_DEFINITION_USER_ERROR_INVALID_BEGIN_TIME.getCounter().increment();
            throw new IllegalArgumentException("beginTimeMs field absent");
        }
        if (endTime == null) {
            InContextReportCreateRequest $this$_init__u24lambda_u241 = this;
            boolean bl = false;
            Metrics.REPORT_FROM_DEFINITION_USER_ERROR_INVALID_END_TIME.getCounter().increment();
            throw new IllegalArgumentException("endTimeMs field absent");
        }
        if (status == null) {
            InContextReportCreateRequest $this$_init__u24lambda_u242 = this;
            boolean bl = false;
            Metrics.REPORT_FROM_DEFINITION_USER_ERROR_INVALID_STATUS.getCounter().increment();
            throw new IllegalArgumentException("status field absent");
        }
        this.beginTime = beginTime;
        this.endTime = endTime;
        this.reportDefinitionDetails = reportDefinitionDetails;
        this.status = status;
        this.statusText = statusText;
        this.inContextDownloadUrlPath = inContextDownloadUrlPath;
    }

    public void writeTo(@NotNull StreamOutput output) throws IOException {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        this.toXContent(XContentFactory.jsonBuilder((OutputStream)((OutputStream)output)), ToXContent.EMPTY_PARAMS);
    }

    @Nullable
    public final XContentBuilder toXContent(@NotNull ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        return this.toXContent(XContentFactory.jsonBuilder(), params);
    }

    public static /* synthetic */ XContentBuilder toXContent$default(InContextReportCreateRequest inContextReportCreateRequest, ToXContent.Params params, int n, Object object) {
        if ((n & 1) != 0) {
            ToXContent.Params params2 = ToXContent.EMPTY_PARAMS;
            Intrinsics.checkNotNullExpressionValue((Object)params2, (String)"EMPTY_PARAMS");
            params = params2;
        }
        return inContextReportCreateRequest.toXContent(params);
    }

    @NotNull
    public XContentBuilder toXContent(@Nullable XContentBuilder builder, @Nullable ToXContent.Params params) {
        XContentBuilder xContentBuilder = builder;
        Intrinsics.checkNotNull((Object)xContentBuilder);
        xContentBuilder.startObject().field("beginTimeMs", this.beginTime.toEpochMilli()).field("endTimeMs", this.endTime.toEpochMilli());
        if (this.reportDefinitionDetails != null) {
            builder.field("reportDefinitionDetails");
            this.reportDefinitionDetails.toXContent(builder, RestTag.INSTANCE.getREST_OUTPUT_PARAMS());
        }
        XContentBuilder xContentBuilder2 = builder.field("status", this.status.name());
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder2, (String)"builder.field(STATUS_FIELD, status.name)");
        XContentBuilder xContentBuilder3 = HelpersKt.fieldIfNotNull(HelpersKt.fieldIfNotNull(xContentBuilder2, "statusText", this.statusText), "inContextDownloadUrlPath", this.inContextDownloadUrlPath).endObject();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder3, (String)"builder.field(STATUS_FIE\u2026\n            .endObject()");
        return xContentBuilder3;
    }

    @Nullable
    public ActionRequestValidationException validate() {
        return null;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/opensearch/reportsscheduler/model/InContextReportCreateRequest$Companion;", "", "()V", "log", "Lorg/apache/logging/log4j/Logger;", "getLog", "()Lorg/apache/logging/log4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "opensearch-reports-scheduler"})
    public static final class Companion {
        private Companion() {
        }

        private final Logger getLog() {
            Lazy lazy = log$delegate;
            return (Logger)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

