/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.ratelimit;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.action.update.UpdateRequest;
import org.opensearch.ad.caching.CacheProvider;
import org.opensearch.ad.ml.CheckpointDao;
import org.opensearch.ad.ml.EntityModel;
import org.opensearch.ad.ml.ModelState;
import org.opensearch.ad.ratelimit.CheckpointMaintainRequest;
import org.opensearch.ad.ratelimit.CheckpointWriteRequest;
import org.opensearch.ad.util.DateUtils;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.common.Strings;

public class CheckPointMaintainRequestAdapter {
    private static final Logger LOG = LogManager.getLogger(CheckPointMaintainRequestAdapter.class);
    private CacheProvider cache;
    private CheckpointDao checkpointDao;
    private String indexName;
    private Duration checkpointInterval;
    private Clock clock;

    public CheckPointMaintainRequestAdapter(CacheProvider cache, CheckpointDao checkpointDao, String indexName, Setting<TimeValue> checkpointIntervalSetting, Clock clock, ClusterService clusterService, Settings settings) {
        this.cache = cache;
        this.checkpointDao = checkpointDao;
        this.indexName = indexName;
        this.checkpointInterval = DateUtils.toDuration((TimeValue)checkpointIntervalSetting.get(settings));
        clusterService.getClusterSettings().addSettingsUpdateConsumer(checkpointIntervalSetting, it -> {
            this.checkpointInterval = DateUtils.toDuration(it);
        });
        this.clock = clock;
    }

    public Optional<CheckpointWriteRequest> convert(CheckpointMaintainRequest request) {
        String detectorId = request.getDetectorId();
        String modelId = request.getEntityModelId();
        Optional<ModelState<EntityModel>> stateToMaintain = this.cache.get().getForMaintainance(detectorId, modelId);
        if (!stateToMaintain.isEmpty()) {
            ModelState<EntityModel> state = stateToMaintain.get();
            Instant instant = state.getLastCheckpointTime();
            if (!this.checkpointDao.shouldSave(instant, false, this.checkpointInterval, this.clock)) {
                return Optional.empty();
            }
            try {
                Map<String, Object> source = this.checkpointDao.toIndexSource(state);
                if (source == null || source.isEmpty() || Strings.isEmpty((CharSequence)modelId)) {
                    return Optional.empty();
                }
                return Optional.of(new CheckpointWriteRequest(request.getExpirationEpochMs(), detectorId, request.getPriority(), new UpdateRequest(this.indexName, modelId).docAsUpsert(true).doc(source)));
            }
            catch (Exception e) {
                LOG.error((Message)new ParameterizedMessage("Exception while serializing models for [{}]", (Object)modelId), (Throwable)e);
            }
        }
        return Optional.empty();
    }
}

