/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.parkservices.state.threshold;

import com.amazon.randomcutforest.parkservices.state.statistics.DeviationMapper;
import com.amazon.randomcutforest.parkservices.state.threshold.BasicThresholderState;
import com.amazon.randomcutforest.parkservices.statistics.Deviation;
import com.amazon.randomcutforest.parkservices.threshold.BasicThresholder;
import com.amazon.randomcutforest.state.IStateMapper;

public class BasicThresholderMapper
implements IStateMapper<BasicThresholder, BasicThresholderState> {
    public BasicThresholder toModel(BasicThresholderState state, long seed) {
        DeviationMapper deviationMapper = new DeviationMapper();
        Deviation[] deviations = null;
        if (state.getDeviationStates() != null) {
            deviations = DeviationMapper.getDeviations(state.getDeviationStates(), deviationMapper);
        } else if (state.getPrimaryDeviationState() != null) {
            deviations = new Deviation[]{(Deviation)deviationMapper.toModel(state.getPrimaryDeviationState()), (Deviation)deviationMapper.toModel(state.getSecondaryDeviationState()), (Deviation)deviationMapper.toModel(state.getThresholdDeviationState())};
        }
        BasicThresholder thresholder = new BasicThresholder(deviations);
        thresholder.setAbsoluteThreshold(state.getAbsoluteThreshold());
        thresholder.setLowerThreshold(state.getLowerThreshold());
        thresholder.setInitialThreshold(state.getInitialThreshold());
        thresholder.setScoreDifferencing(state.getHorizon());
        thresholder.setCount(state.getCount());
        thresholder.setAutoThreshold(state.isAutoThreshold());
        thresholder.setMinimumScores(state.getMinimumScores());
        thresholder.setZfactor(state.getZFactor());
        return thresholder;
    }

    public BasicThresholderState toState(BasicThresholder model) {
        BasicThresholderState state = new BasicThresholderState();
        DeviationMapper deviationMapper = new DeviationMapper();
        state.setZFactor(model.getZFactor());
        state.setLowerThreshold(model.getLowerThreshold());
        state.setAbsoluteThreshold(model.getAbsoluteThreshold());
        state.setInitialThreshold(model.getInitialThreshold());
        state.setCount(model.getCount());
        state.setAutoThreshold(model.isAutoThreshold());
        state.setMinimumScores(model.getMinimumScores());
        state.setDeviationStates(DeviationMapper.getStates(model.getDeviations(), deviationMapper));
        state.setHorizon(model.getScoreDifferencing());
        return state;
    }
}

