/* libmirage.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "Mirage", gir_namespace = "Mirage", gir_version = "3.2", lower_case_cprefix = "mirage_")]
namespace Mirage {
	[CCode (cheader_filename = "mirage/mirage.h", lower_case_csuffix = "cdtext_coder", type_id = "mirage_cdtext_coder_get_type ()")]
	public class CdTextCoder : Mirage.Object, Mirage.Contextual {
		[CCode (has_construct_function = false)]
		protected CdTextCoder ();
	}
	[CCode (cheader_filename = "mirage/mirage.h", type_id = "mirage_context_get_type ()")]
	public class Context : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Context ();
		public void clear_options ();
		public Mirage.Stream create_input_stream (string filename) throws GLib.Error;
		public Mirage.Stream create_output_stream (string filename, [CCode (array_length = false, array_null_terminated = true)] string[]? filter_chain) throws GLib.Error;
		public unowned string get_debug_domain ();
		public int get_debug_mask ();
		public unowned string get_debug_name ();
		public GLib.Variant get_option (string name);
		public Mirage.Disc load_image ([CCode (array_length = false, array_null_terminated = true)] string[] filenames) throws GLib.Error;
		public string obtain_password () throws GLib.Error;
		public void set_debug_domain (string domain);
		public void set_debug_mask (int debug_mask);
		public void set_debug_name (string name);
		public void set_option (string name, owned GLib.Variant value);
		public void set_password_function (owned Mirage.PasswordFunction? func);
	}
	[CCode (cheader_filename = "mirage/mirage.h", type_id = "mirage_disc_get_type ()")]
	public class Disc : Mirage.Object, Mirage.Contextual {
		[CCode (has_construct_function = false)]
		protected Disc ();
		public void add_session_by_index (int index, owned Mirage.Session session);
		public bool add_session_by_number (int number, owned Mirage.Session session) throws GLib.Error;
		public bool add_track_by_index (int index, owned Mirage.Track track) throws GLib.Error;
		public bool add_track_by_number (int number, owned Mirage.Track track) throws GLib.Error;
		public bool enumerate_sessions (Mirage.EnumSessionCallback func);
		public bool get_disc_structure (int layer, int type, [CCode (array_length_cname = "len", array_length_pos = 3.1)] out unowned uint8[] data) throws GLib.Error;
		public void get_dpm_data (out int start, out int resolution, [CCode (array_length_cname = "num_entries", array_length_pos = 2.5)] out unowned uint32[] data);
		public bool get_dpm_data_for_sector (int address, out double angle, out double density) throws GLib.Error;
		[CCode (array_length = false, array_null_terminated = true)]
		public unowned string[] get_filenames ();
		public Mirage.MediumType get_medium_type ();
		public int get_number_of_sessions ();
		public int get_number_of_tracks ();
		public Mirage.Sector get_sector (int address) throws GLib.Error;
		public Mirage.Session get_session_after (Mirage.Session session) throws GLib.Error;
		public Mirage.Session get_session_before (Mirage.Session session) throws GLib.Error;
		public Mirage.Session get_session_by_address (int address) throws GLib.Error;
		public Mirage.Session get_session_by_index (int index) throws GLib.Error;
		public Mirage.Session get_session_by_number (int number) throws GLib.Error;
		public Mirage.Session get_session_by_track (int track) throws GLib.Error;
		public Mirage.Track get_track_by_address (int address) throws GLib.Error;
		public Mirage.Track get_track_by_index (int index) throws GLib.Error;
		public Mirage.Track get_track_by_number (int number) throws GLib.Error;
		public bool layout_contains_address (int address);
		public int layout_get_first_session ();
		public int layout_get_first_track ();
		public int layout_get_length ();
		public int layout_get_start_sector ();
		public void layout_set_first_session (int first_session);
		public void layout_set_first_track (int first_track);
		public void layout_set_start_sector (int start_sector);
		public bool put_sector (Mirage.Sector sector) throws GLib.Error;
		public bool remove_session_by_index (int index) throws GLib.Error;
		public bool remove_session_by_number (int number) throws GLib.Error;
		public void remove_session_by_object (Mirage.Session session);
		public bool remove_track_by_index (int index) throws GLib.Error;
		public bool remove_track_by_number (int number) throws GLib.Error;
		public void set_disc_structure (int layer, int type, [CCode (array_length_cname = "len", array_length_pos = 3.1)] uint8[] data);
		public void set_dpm_data (int start, int resolution, [CCode (array_length_cname = "num_entries", array_length_pos = 2.5)] uint32[] data);
		public void set_filename (string filename);
		public void set_filenames ([CCode (array_length = false, array_null_terminated = true)] string[] filenames);
		public void set_medium_type (Mirage.MediumType medium_type);
		public signal void layout_changed ();
	}
	[CCode (cheader_filename = "mirage/mirage.h", type_id = "mirage_file_stream_get_type ()")]
	public class FileStream : Mirage.Object, Mirage.Contextual, Mirage.Stream {
		[CCode (has_construct_function = false)]
		protected FileStream ();
		public bool open (string filename, bool writable) throws GLib.Error;
	}
	[CCode (cheader_filename = "mirage/mirage.h", type_id = "mirage_filter_stream_get_type ()")]
	public abstract class FilterStream : Mirage.Object, Mirage.Contextual, Mirage.Stream {
		[CCode (has_construct_function = false)]
		protected FilterStream ();
		public unowned Mirage.FilterStreamInfo? get_info ();
		public unowned Mirage.Stream get_underlying_stream ();
		public virtual bool open (Mirage.Stream stream, bool writable) throws GLib.Error;
		[NoWrapper]
		public virtual ssize_t read (void* buffer, size_t count) throws GLib.Error;
		[NoWrapper]
		public virtual bool seek (int64 offset, GLib.SeekType type) throws GLib.Error;
		public int64 simplified_get_position ();
		[NoWrapper]
		public virtual ssize_t simplified_partial_read (void* buffer, size_t count);
		[NoWrapper]
		public virtual ssize_t simplified_partial_write (void* buffer, size_t count);
		public void simplified_set_stream_length (size_t length);
		[NoWrapper]
		public virtual int64 tell ();
		[NoWrapper]
		public virtual ssize_t write (void* buffer, size_t count) throws GLib.Error;
	}
	[CCode (cheader_filename = "mirage/mirage.h", type_id = "mirage_fragment_get_type ()")]
	public class Fragment : Mirage.Object, Mirage.Contextual {
		[CCode (has_construct_function = false)]
		protected Fragment ();
		public bool contains_address (int address);
		public int get_address ();
		public int get_length ();
		public bool is_writable ();
		public unowned string main_data_get_filename ();
		public int main_data_get_format ();
		public uint64 main_data_get_offset ();
		public int main_data_get_size ();
		public void main_data_set_format (int format);
		public void main_data_set_offset (uint64 offset);
		public void main_data_set_size (int size);
		public void main_data_set_stream (owned Mirage.Stream stream);
		public bool read_main_data (int address, [CCode (array_length_cname = "length", array_length_pos = 2.1)] out uint8[] buffer) throws GLib.Error;
		public bool read_subchannel_data (int address, [CCode (array_length_cname = "length", array_length_pos = 2.1)] uint8[]? buffer) throws GLib.Error;
		public void set_address (int address);
		public void set_length (int length);
		public unowned string subchannel_data_get_filename ();
		public int subchannel_data_get_format ();
		public uint64 subchannel_data_get_offset ();
		public int subchannel_data_get_size ();
		public void subchannel_data_set_format (int format);
		public void subchannel_data_set_offset (uint64 offset);
		public void subchannel_data_set_size (int size);
		public void subchannel_data_set_stream (owned Mirage.Stream stream);
		public bool use_the_rest_of_file () throws GLib.Error;
		public bool write_main_data (int address, [CCode (array_length_cname = "length", array_length_pos = 2.1)] uint8[]? buffer) throws GLib.Error;
		public bool write_subchannel_data (int address, [CCode (array_length_cname = "length", array_length_pos = 2.1)] uint8[]? buffer) throws GLib.Error;
		public signal void layout_changed ();
	}
	[CCode (cheader_filename = "mirage/mirage.h", type_id = "mirage_index_get_type ()")]
	public class Index : Mirage.Object, Mirage.Contextual {
		[CCode (has_construct_function = false)]
		protected Index ();
		public int get_address ();
		public int get_number ();
		public void set_address (int address);
		public void set_number (int number);
	}
	[CCode (cheader_filename = "mirage/mirage.h", type_id = "mirage_language_get_type ()")]
	public class Language : Mirage.Object, Mirage.Contextual {
		[CCode (has_construct_function = false)]
		protected Language ();
		public int get_code ();
		public bool get_pack_data (Mirage.LanguagePackType pack_type, [CCode (array_length_cname = "length", array_length_pos = 2.1)] out unowned uint8[] pack_data) throws GLib.Error;
		public void set_code (int code);
		public bool set_pack_data (Mirage.LanguagePackType pack_type, [CCode (array_length_cname = "length", array_length_pos = 2.1)] uint8[] pack_data) throws GLib.Error;
	}
	[CCode (cheader_filename = "mirage/mirage.h", type_id = "mirage_object_get_type ()")]
	public class Object : GLib.Object, Mirage.Contextual {
		[CCode (has_construct_function = false)]
		protected Object ();
		public Mirage.Object get_parent ();
		public void set_parent (Mirage.Object? parent);
		public signal void context_changed ();
	}
	[CCode (cheader_filename = "mirage/mirage.h", type_id = "mirage_parser_get_type ()")]
	public abstract class Parser : Mirage.Object, Mirage.Contextual {
		[CCode (has_construct_function = false)]
		protected Parser ();
		public void add_redbook_pregap (Mirage.Disc disc);
		public GLib.DataInputStream create_text_stream (owned Mirage.Stream stream) throws GLib.Error;
		public unowned Mirage.ParserInfo? get_info ();
		public int guess_medium_type (Mirage.Disc disc);
		public virtual Mirage.Disc load_image ([CCode (array_length = false, array_null_terminated = true)] Mirage.Stream[] streams) throws GLib.Error;
	}
	[CCode (cheader_filename = "mirage/mirage.h", type_id = "mirage_plugin_get_type ()")]
	public class Plugin : GLib.TypeModule, GLib.TypePlugin {
		[CCode (has_construct_function = false)]
		public Plugin (string filename);
		[NoAccessorMethod]
		public string filename { owned get; construct; }
	}
	[CCode (cheader_filename = "mirage/mirage.h", type_id = "mirage_sector_get_type ()")]
	public class Sector : Mirage.Object, Mirage.Contextual {
		[CCode (has_construct_function = false)]
		protected Sector ();
		public bool extract_data (out uint8 main_data, uint main_data_length, out Mirage.SectorSubchannelFormat subchannel_format, uint8? subchannel_data, uint subchannel_data_length) throws GLib.Error;
		public bool feed_data (int address, Mirage.SectorType type, uint8 main_data, uint main_data_length, Mirage.SectorSubchannelFormat subchannel_format, uint8? subchannel_data, uint subchannel_data_length, int ignore_data_mask) throws GLib.Error;
		public int get_address ();
		public bool get_data ([CCode (array_length_cname = "ret_len", array_length_pos = 1.1)] out unowned uint8[] ret_buf) throws GLib.Error;
		public bool get_edc_ecc ([CCode (array_length_cname = "ret_len", array_length_pos = 1.1)] out unowned uint8[] ret_buf) throws GLib.Error;
		public bool get_header ([CCode (array_length_cname = "ret_len", array_length_pos = 1.1)] out unowned uint8[] ret_buf) throws GLib.Error;
		public Mirage.SectorType get_sector_type ();
		public bool get_subchannel (Mirage.SectorSubchannelFormat format, [CCode (array_length_cname = "ret_len", array_length_pos = 2.1)] out unowned uint8[] ret_buf) throws GLib.Error;
		public bool get_subheader ([CCode (array_length_cname = "ret_len", array_length_pos = 1.1)] out unowned uint8[] ret_buf) throws GLib.Error;
		public bool get_sync ([CCode (array_length_cname = "ret_len", array_length_pos = 1.1)] out unowned uint8[] ret_buf) throws GLib.Error;
		public void scramble ();
		public bool set_data ([CCode (array_length_cname = "len", array_length_pos = 1.1)] uint8[] buf) throws GLib.Error;
		public bool set_edc_ecc ([CCode (array_length_cname = "len", array_length_pos = 1.1)] uint8[] buf) throws GLib.Error;
		public bool set_header ([CCode (array_length_cname = "len", array_length_pos = 1.1)] uint8[] buf) throws GLib.Error;
		public bool set_subchannel (Mirage.SectorSubchannelFormat format, [CCode (array_length_cname = "len", array_length_pos = 2.1)] uint8[] buf) throws GLib.Error;
		public bool set_subheader ([CCode (array_length_cname = "len", array_length_pos = 1.1)] uint8[] buf) throws GLib.Error;
		public bool set_sync ([CCode (array_length_cname = "len", array_length_pos = 1.1)] uint8[] buf) throws GLib.Error;
		public bool verify_lec ();
		public bool verify_subchannel_crc ();
	}
	[CCode (cheader_filename = "mirage/mirage.h", type_id = "mirage_session_get_type ()")]
	public class Session : Mirage.Object, Mirage.Contextual {
		[CCode (has_construct_function = false)]
		protected Session ();
		public bool add_language (int code, owned Mirage.Language language) throws GLib.Error;
		public void add_track_by_index (int index, owned Mirage.Track track);
		public bool add_track_by_number (int number, owned Mirage.Track track) throws GLib.Error;
		public bool enumerate_languages (Mirage.EnumLanguageCallback func);
		public bool enumerate_tracks (Mirage.EnumTrackCallback func);
		public bool get_cdtext_data ([CCode (array_length_cname = "len", array_length_pos = 1.1)] out uint8[] data) throws GLib.Error;
		public Mirage.Language get_language_by_code (int code) throws GLib.Error;
		public Mirage.Language get_language_by_index (int index) throws GLib.Error;
		public int get_leadout_length ();
		public unowned string get_mcn ();
		public Mirage.Session get_next () throws GLib.Error;
		public int get_number_of_languages ();
		public int get_number_of_tracks ();
		public Mirage.Session get_prev () throws GLib.Error;
		public Mirage.SessionType get_session_type ();
		public Mirage.Track get_track_after (Mirage.Track track) throws GLib.Error;
		public Mirage.Track get_track_before (Mirage.Track track) throws GLib.Error;
		public Mirage.Track get_track_by_address (int address) throws GLib.Error;
		public Mirage.Track get_track_by_index (int index) throws GLib.Error;
		public Mirage.Track get_track_by_number (int number) throws GLib.Error;
		public bool layout_contains_address (int address);
		public int layout_get_first_track ();
		public int layout_get_length ();
		public int layout_get_session_number ();
		public int layout_get_start_sector ();
		public void layout_set_first_track (int first_track);
		public void layout_set_session_number (int number);
		public void layout_set_start_sector (int start_sector);
		public bool remove_language_by_code (int code) throws GLib.Error;
		public bool remove_language_by_index (int index) throws GLib.Error;
		public void remove_language_by_object (Mirage.Language language);
		public bool remove_track_by_index (int index) throws GLib.Error;
		public bool remove_track_by_number (int number) throws GLib.Error;
		public void remove_track_by_object (Mirage.Track track);
		public bool set_cdtext_data ([CCode (array_length_cname = "len", array_length_pos = 1.1)] uint8[] data) throws GLib.Error;
		public void set_leadout_length (int length);
		public void set_mcn (string mcn);
		public void set_session_type (Mirage.SessionType type);
		public signal void layout_changed ();
	}
	[CCode (cheader_filename = "mirage/mirage.h", type_id = "mirage_track_get_type ()")]
	public class Track : Mirage.Object, Mirage.Contextual {
		[CCode (has_construct_function = false)]
		protected Track ();
		public void add_fragment (int index, Mirage.Fragment fragment);
		public bool add_index (int address) throws GLib.Error;
		public bool add_language (int code, owned Mirage.Language? language) throws GLib.Error;
		public bool enumerate_fragments (Mirage.EnumFragmentCallback func);
		public bool enumerate_indices (Mirage.EnumIndexCallback func);
		public bool enumerate_languages (Mirage.EnumLanguageCallback func);
		public Mirage.Fragment find_fragment_with_subchannel () throws GLib.Error;
		public int get_adr ();
		public int get_ctl ();
		public int get_flags ();
		public Mirage.Fragment get_fragment_by_address (int address) throws GLib.Error;
		public Mirage.Fragment get_fragment_by_index (int index) throws GLib.Error;
		public Mirage.Index get_index_by_address (int address) throws GLib.Error;
		public Mirage.Index get_index_by_number (int number) throws GLib.Error;
		public unowned string get_isrc ();
		public Mirage.Language get_language_by_code (int code) throws GLib.Error;
		public Mirage.Language get_language_by_index (int index) throws GLib.Error;
		public Mirage.Track get_next () throws GLib.Error;
		public int get_number_of_fragments ();
		public int get_number_of_indices ();
		public int get_number_of_languages ();
		public Mirage.Track get_prev () throws GLib.Error;
		public Mirage.Sector get_sector (int address, bool abs) throws GLib.Error;
		public Mirage.SectorType get_sector_type ();
		public int get_track_start ();
		public bool layout_contains_address (int address);
		public int layout_get_length ();
		public int layout_get_session_number ();
		public int layout_get_start_sector ();
		public int layout_get_track_number ();
		public void layout_set_start_sector (int start_sector);
		public void layout_set_track_number (int track_number);
		public bool put_sector (Mirage.Sector sector) throws GLib.Error;
		public bool remove_fragment_by_index (int index) throws GLib.Error;
		public void remove_fragment_by_object (Mirage.Fragment fragment);
		public bool remove_index_by_number (int number) throws GLib.Error;
		public void remove_index_by_object (Mirage.Index index);
		public bool remove_language_by_code (int code) throws GLib.Error;
		public bool remove_language_by_index (int index) throws GLib.Error;
		public void remove_language_by_object (Mirage.Language language);
		public void set_ctl (int ctl);
		public void set_flags (int flags);
		public void set_isrc (string isrc);
		public void set_sector_type (Mirage.SectorType sector_type);
		public void set_track_start (int track_start);
		public signal void layout_changed ();
	}
	[CCode (cheader_filename = "mirage/mirage.h", type_id = "mirage_writer_get_type ()")]
	public abstract class Writer : Mirage.Object, Mirage.Contextual {
		[CCode (has_construct_function = false)]
		protected Writer ();
		public void add_parameter_boolean (string id, string name, string description, bool default_value);
		public void add_parameter_int (string id, string name, string description, int default_value);
		public void add_parameter_string (string id, string name, string description, string default_value);
		public bool convert_image (string filename, Mirage.Disc original_disc, GLib.HashTable<string,GLib.Variant> parameters, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public virtual Mirage.Fragment create_fragment (Mirage.Track track, Mirage.FragmentRole role) throws GLib.Error;
		public virtual bool finalize_image (Mirage.Disc disc) throws GLib.Error;
		public void generate_info (string id, string name);
		public uint get_conversion_progress_step ();
		public unowned Mirage.WriterInfo? get_info ();
		public bool get_parameter_boolean (string id);
		public unowned string get_parameter_enum (string id);
		public int get_parameter_int (string id);
		public unowned string get_parameter_string (string id);
		public unowned GLib.List<string> lookup_parameter_ids ();
		public unowned Mirage.WriterParameter? lookup_parameter_info (string id);
		public bool open_image (Mirage.Disc disc, GLib.HashTable<string,GLib.Variant> parameters) throws GLib.Error;
		[NoWrapper]
		public virtual bool open_image_impl (Mirage.Disc disc) throws GLib.Error;
		public void set_conversion_progress_step (uint step);
		public signal void conversion_progress (uint progress);
	}
	[CCode (cheader_filename = "mirage/mirage.h", type_cname = "MirageContextualInterface", type_id = "mirage_contextual_get_type ()")]
	public interface Contextual : GLib.Object {
		public Mirage.Stream create_input_stream (string filename) throws GLib.Error;
		public Mirage.Stream create_output_stream (string filename, [CCode (array_length = false, array_null_terminated = true)] string[]? filter_chain) throws GLib.Error;
		public bool debug_is_active (int level);
		public void debug_print_buffer (int level, string? prefix, int width, [CCode (array_length_cname = "buffer_length", array_length_pos = 4.1)] uint8[] buffer);
		public abstract Mirage.Context get_context ();
		public GLib.Variant get_option (string name);
		public string obtain_password () throws GLib.Error;
		public abstract void set_context (owned Mirage.Context context);
	}
	[CCode (cheader_filename = "mirage/mirage.h", type_cname = "MirageStreamInterface", type_id = "mirage_stream_get_type ()")]
	public interface Stream : GLib.Object {
		public abstract unowned string get_filename ();
		public GLib.InputStream get_g_input_stream ();
		public abstract bool is_writable ();
		public abstract bool move_file (string new_filename) throws GLib.Error;
		public abstract ssize_t read (void* buffer, size_t count) throws GLib.Error;
		public abstract bool seek (int64 offset, GLib.SeekType type) throws GLib.Error;
		public abstract int64 tell ();
		public abstract ssize_t write (void* buffer, size_t count) throws GLib.Error;
	}
	[CCode (cheader_filename = "mirage/mirage.h", has_type_id = false)]
	public struct DebugMaskInfo {
		public weak string name;
		public int value;
	}
	[CCode (cheader_filename = "mirage/mirage.h", has_type_id = false)]
	public struct FilterStreamInfo {
		public weak string id;
		public weak string name;
		public bool writable;
		[CCode (array_length = false, array_null_terminated = true)]
		public weak string[] description;
		[CCode (array_length = false, array_null_terminated = true)]
		public weak string[] mime_type;
		public void copy (Mirage.FilterStreamInfo dest);
		public void free ();
	}
	[CCode (cheader_filename = "mirage/mirage.h", has_type_id = false)]
	public struct ParserInfo {
		public weak string id;
		public weak string name;
		[CCode (array_length = false, array_null_terminated = true)]
		public weak string[] description;
		[CCode (array_length = false, array_null_terminated = true)]
		public weak string[] mime_type;
		public void copy (Mirage.ParserInfo dest);
		public void free ();
	}
	[CCode (cheader_filename = "mirage/mirage.h", has_type_id = false)]
	public struct WriterInfo {
		public weak string id;
		public weak string name;
		public void copy (Mirage.WriterInfo dest);
		public void free ();
	}
	[CCode (cheader_filename = "mirage/mirage.h", has_type_id = false)]
	public struct WriterParameter {
		public weak string name;
		public weak string description;
		public weak GLib.Variant default_value;
		public weak GLib.Variant enum_values;
	}
	[CCode (cheader_filename = "mirage/mirage.h", cprefix = "MIRAGE_DEBUG_", has_type_id = false)]
	public enum DebugMask {
		ERROR,
		WARNING,
		PARSER,
		DISC,
		SESSION,
		TRACK,
		SECTOR,
		FRAGMENT,
		CDTEXT,
		STREAM,
		IMAGE_ID,
		WRITER
	}
	[CCode (cheader_filename = "mirage/mirage.h", cprefix = "MIRAGE_ERROR_", has_type_id = false)]
	public enum ErrorCode {
		LIBRARY_ERROR,
		PARSER_ERROR,
		FRAGMENT_ERROR,
		DISC_ERROR,
		LANGUAGE_ERROR,
		SECTOR_ERROR,
		SESSION_ERROR,
		TRACK_ERROR,
		STREAM_ERROR,
		IMAGE_FILE_ERROR,
		DATA_FILE_ERROR,
		CANNOT_HANDLE,
		ENCRYPTED_IMAGE,
		WRITER_ERROR
	}
	[CCode (cheader_filename = "mirage/mirage.h", cprefix = "MIRAGE_FRAGMENT_", has_type_id = false)]
	public enum FragmentRole {
		PREGAP,
		DATA
	}
	[CCode (cheader_filename = "mirage/mirage.h", cprefix = "MIRAGE_LANGUAGE_PACK_", has_type_id = false)]
	public enum LanguagePackType {
		TITLE,
		PERFORMER,
		SONGWRITER,
		COMPOSER,
		ARRANGER,
		MESSAGE,
		DISC_ID,
		GENRE,
		TOC,
		TOC2,
		RES_8A,
		RES_8B,
		RES_8C,
		CLOSED_INFO,
		UPC_ISRC,
		SIZE
	}
	[CCode (cheader_filename = "mirage/mirage.h", cprefix = "MIRAGE_MAIN_DATA_FORMAT_", has_type_id = false)]
	public enum MainDataFormat {
		DATA,
		AUDIO,
		AUDIO_SWAP
	}
	[CCode (cheader_filename = "mirage/mirage.h", cprefix = "MIRAGE_MEDIUM_", has_type_id = false)]
	public enum MediumType {
		CD,
		DVD,
		BD,
		HD,
		HDD
	}
	[CCode (cheader_filename = "mirage/mirage.h", cprefix = "MIRAGE_SUBCHANNEL_", has_type_id = false)]
	public enum SectorSubchannelFormat {
		NONE,
		PW,
		Q,
		RW
	}
	[CCode (cheader_filename = "mirage/mirage.h", cprefix = "MIRAGE_SECTOR_", has_type_id = false)]
	public enum SectorType {
		MODE0,
		AUDIO,
		MODE1,
		MODE2,
		MODE2_FORM1,
		MODE2_FORM2,
		MODE2_MIXED,
		RAW,
		RAW_SCRAMBLED
	}
	[CCode (cheader_filename = "mirage/mirage.h", cprefix = "MIRAGE_VALID_", has_type_id = false)]
	public enum SectorValidData {
		SYNC,
		HEADER,
		SUBHEADER,
		DATA,
		EDC_ECC,
		SUBCHAN
	}
	[CCode (cheader_filename = "mirage/mirage.h", cprefix = "MIRAGE_SESSION_", has_type_id = false)]
	public enum SessionType {
		CDDA,
		CDROM,
		CDI,
		CDROM_XA
	}
	[CCode (cheader_filename = "mirage/mirage.h", cprefix = "SUBCHANNEL_", has_type_id = false)]
	public enum SubChannel {
		W,
		V,
		U,
		T,
		S,
		R,
		Q,
		P
	}
	[CCode (cheader_filename = "mirage/mirage.h", cprefix = "MIRAGE_SUBCHANNEL_DATA_FORMAT_", has_type_id = false)]
	public enum SubchannelDataFormat {
		INTERNAL,
		EXTERNAL,
		PW96_INTERLEAVED,
		PW96_LINEAR,
		RW96,
		Q16
	}
	[CCode (cheader_filename = "mirage/mirage.h", cprefix = "MIRAGE_TRACK_", has_type_id = false)]
	public enum TrackConstant {
		LEADIN,
		LEADOUT
	}
	[CCode (cheader_filename = "mirage/mirage.h", cprefix = "MIRAGE_TRACK_FLAG_", has_type_id = false)]
	public enum TrackFlag {
		FOURCHANNEL,
		COPYPERMITTED,
		PREEMPHASIS
	}
	[CCode (cheader_filename = "mirage/mirage.h", cprefix = "MIRAGE_ERROR_", type_id = "mirage_error_get_type ()")]
	public errordomain Error {
		[CCode (cname = "MIRAGE_ERROR_LIBRARY_ERROR")]
		LIBRARYERROR,
		[CCode (cname = "MIRAGE_ERROR_PARSER_ERROR")]
		PARSERERROR,
		[CCode (cname = "MIRAGE_ERROR_FRAGMENT_ERROR")]
		FRAGMENTERROR,
		[CCode (cname = "MIRAGE_ERROR_DISC_ERROR")]
		DISCERROR,
		[CCode (cname = "MIRAGE_ERROR_LANGUAGE_ERROR")]
		LANGUAGEERROR,
		[CCode (cname = "MIRAGE_ERROR_SECTOR_ERROR")]
		SECTORERROR,
		[CCode (cname = "MIRAGE_ERROR_SESSION_ERROR")]
		SESSIONERROR,
		[CCode (cname = "MIRAGE_ERROR_TRACK_ERROR")]
		TRACKERROR,
		[CCode (cname = "MIRAGE_ERROR_STREAM_ERROR")]
		STREAMERROR,
		[CCode (cname = "MIRAGE_ERROR_IMAGE_FILE_ERROR")]
		IMAGEFILEERROR,
		[CCode (cname = "MIRAGE_ERROR_DATA_FILE_ERROR")]
		DATAFILEERROR,
		[CCode (cname = "MIRAGE_ERROR_CANNOT_HANDLE")]
		CANNOTHANDLE,
		[CCode (cname = "MIRAGE_ERROR_ENCRYPTED_IMAGE")]
		ENCRYPTEDIMAGE,
		[CCode (cname = "MIRAGE_ERROR_WRITER_ERROR")]
		WRITERERROR;
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "mirage/mirage.h", instance_pos = 4.9)]
	public delegate bool CdTextDataCallback (int code, int type, int track, [CCode (array_length_cname = "data_len", array_length_pos = 4.1)] uint8[] data);
	[CCode (cheader_filename = "mirage/mirage.h", instance_pos = 1.9)]
	public delegate bool EnumFilterStreamInfoCallback (Mirage.FilterStreamInfo info);
	[CCode (cheader_filename = "mirage/mirage.h", instance_pos = 1.9)]
	public delegate bool EnumFragmentCallback (Mirage.Fragment fragment);
	[CCode (cheader_filename = "mirage/mirage.h", instance_pos = 1.9)]
	public delegate bool EnumIndexCallback (Mirage.Index index);
	[CCode (cheader_filename = "mirage/mirage.h", instance_pos = 1.9)]
	public delegate bool EnumLanguageCallback (Mirage.Language language);
	[CCode (cheader_filename = "mirage/mirage.h", instance_pos = 1.9)]
	public delegate bool EnumParserInfoCallback (Mirage.ParserInfo info);
	[CCode (cheader_filename = "mirage/mirage.h", instance_pos = 1.9)]
	public delegate bool EnumSessionCallback (Mirage.Session session);
	[CCode (cheader_filename = "mirage/mirage.h", instance_pos = 1.9)]
	public delegate bool EnumTrackCallback (Mirage.Track track);
	[CCode (cheader_filename = "mirage/mirage.h", instance_pos = 1.9)]
	public delegate bool EnumWriterInfoCallback (Mirage.WriterInfo info);
	[CCode (cheader_filename = "mirage/mirage.h", instance_pos = 0.9)]
	public delegate string PasswordFunction ();
	[CCode (cheader_filename = "mirage/mirage.h", cname = "MIRAGE_ISRC_SIZE")]
	public const int ISRC_SIZE;
	[CCode (cheader_filename = "mirage/mirage.h", cname = "MIRAGE_MCN_SIZE")]
	public const int MCN_SIZE;
	[CCode (cheader_filename = "mirage/mirage.h", cname = "MIRAGE_SOVERSION_MAJOR")]
	public const int SOVERSION_MAJOR;
	[CCode (cheader_filename = "mirage/mirage.h", cname = "MIRAGE_SOVERSION_MINOR")]
	public const int SOVERSION_MINOR;
	[CCode (cheader_filename = "mirage/mirage.h", cname = "MIRAGE_SOVERSION_PATCH")]
	public const int SOVERSION_PATCH;
	[CCode (cheader_filename = "mirage/mirage.h", cname = "MIRAGE_VERSION_LONG")]
	public const string VERSION_LONG;
	[CCode (cheader_filename = "mirage/mirage.h", cname = "MIRAGE_VERSION_MAJOR")]
	public const int VERSION_MAJOR;
	[CCode (cheader_filename = "mirage/mirage.h", cname = "MIRAGE_VERSION_MICRO")]
	public const int VERSION_MICRO;
	[CCode (cheader_filename = "mirage/mirage.h", cname = "MIRAGE_VERSION_MINOR")]
	public const int VERSION_MINOR;
	[CCode (cheader_filename = "mirage/mirage.h", cname = "MIRAGE_VERSION_SHORT")]
	public const string VERSION_SHORT;
	[CCode (cheader_filename = "mirage/mirage.h")]
	public static bool cdtext_decoder_get_block_info (Mirage.CdTextCoder self, int block, out int code, out int charset, out int copyright) throws GLib.Error;
	[CCode (cheader_filename = "mirage/mirage.h")]
	public static bool cdtext_decoder_get_data (Mirage.CdTextCoder self, int block, Mirage.CdTextDataCallback callback_func);
	[CCode (cheader_filename = "mirage/mirage.h")]
	public static void cdtext_decoder_init (Mirage.CdTextCoder self, [CCode (array_length_cname = "buflen", array_length_pos = 2.1)] uint8[] buffer);
	[CCode (cheader_filename = "mirage/mirage.h")]
	public static void cdtext_encoder_add_data (Mirage.CdTextCoder self, int code, int type, int track, [CCode (array_length_cname = "data_len", array_length_pos = 5.1)] uint8[] data);
	[CCode (cheader_filename = "mirage/mirage.h")]
	public static void cdtext_encoder_encode (Mirage.CdTextCoder self, [CCode (array_length_cname = "buflen", array_length_pos = 2.1)] out uint8[] buffer);
	[CCode (cheader_filename = "mirage/mirage.h")]
	public static void cdtext_encoder_init (Mirage.CdTextCoder self, [CCode (array_length_cname = "buflen", array_length_pos = 2.1)] uint8[] buffer);
	[CCode (cheader_filename = "mirage/mirage.h")]
	public static bool cdtext_encoder_set_block_info (Mirage.CdTextCoder self, int block, int code, int charset, int copyright) throws GLib.Error;
	[CCode (cheader_filename = "mirage/mirage.h")]
	public static Mirage.Writer create_writer (string writer_id) throws GLib.Error;
	[CCode (cheader_filename = "mirage/mirage.h")]
	public static bool enumerate_filter_streams (Mirage.EnumFilterStreamInfoCallback func) throws GLib.Error;
	[CCode (cheader_filename = "mirage/mirage.h")]
	public static bool enumerate_parsers (Mirage.EnumParserInfoCallback func) throws GLib.Error;
	[CCode (cheader_filename = "mirage/mirage.h")]
	public static bool enumerate_writers (Mirage.EnumWriterInfoCallback func) throws GLib.Error;
	[CCode (cheader_filename = "mirage/mirage.h")]
	[Version (replacement = "Error.quark")]
	public static GLib.Quark error_quark ();
	[CCode (cheader_filename = "mirage/mirage.h")]
	public static bool get_filter_streams_info ([CCode (array_length_cname = "num_filter_streams", array_length_pos = 1.1)] out unowned Mirage.FilterStreamInfo[] info) throws GLib.Error;
	[CCode (cheader_filename = "mirage/mirage.h")]
	public static bool get_filter_streams_type ([CCode (array_length_cname = "num_filter_streams", array_length_pos = 1.1)] out unowned GLib.Type[] types) throws GLib.Error;
	[CCode (cheader_filename = "mirage/mirage.h")]
	public static bool get_parsers_info ([CCode (array_length_cname = "num_parsers", array_length_pos = 1.1)] out unowned Mirage.ParserInfo[] info) throws GLib.Error;
	[CCode (cheader_filename = "mirage/mirage.h")]
	public static bool get_parsers_type ([CCode (array_length_cname = "num_parsers", array_length_pos = 1.1)] out unowned GLib.Type[] types) throws GLib.Error;
	[CCode (cheader_filename = "mirage/mirage.h")]
	public static bool get_supported_debug_masks ([CCode (array_length_cname = "num_masks", array_length_pos = 1.1)] out unowned Mirage.DebugMaskInfo[] masks) throws GLib.Error;
	[CCode (cheader_filename = "mirage/mirage.h")]
	public static bool get_writers_info ([CCode (array_length_cname = "num_writers", array_length_pos = 1.1)] out unowned Mirage.WriterInfo[] info) throws GLib.Error;
	[CCode (cheader_filename = "mirage/mirage.h")]
	public static bool get_writers_type ([CCode (array_length_cname = "num_writers", array_length_pos = 1.1)] out unowned GLib.Type[] types) throws GLib.Error;
	[CCode (cheader_filename = "mirage/mirage.h")]
	public static uint8 helper_ascii2isrc (char c);
	[CCode (cheader_filename = "mirage/mirage.h")]
	public static int helper_bcd2hex (int bcd);
	[CCode (cheader_filename = "mirage/mirage.h")]
	public static uint16 helper_calculate_crc16 ([CCode (array_length_cname = "length", array_length_pos = 1.5, array_length_type = "guint")] uint8[] data, [CCode (array_length = false)] uint16 crctab[256], bool reflected, bool invert);
	[CCode (cheader_filename = "mirage/mirage.h")]
	public static uint32 helper_calculate_crc32_fast ([CCode (array_length_cname = "length", array_length_pos = 1.5, array_length_type = "guint")] uint8[] data, [CCode (array_length = false)] uint32 crctab[2048], bool reflected, bool invert);
	[CCode (cheader_filename = "mirage/mirage.h")]
	public static uint32 helper_calculate_crc32_standard ([CCode (array_length_cname = "length", array_length_pos = 1.5, array_length_type = "guint")] uint8[] data, [CCode (array_length = false)] uint32 crctab[256], bool reflected, bool invert);
	[CCode (cheader_filename = "mirage/mirage.h")]
	public static Mirage.SectorType helper_determine_sector_type (uint8 buf);
	[CCode (cheader_filename = "mirage/mirage.h")]
	public static unowned string helper_encoding_from_bom ([CCode (array_length = false)] uint8 buffer[4]);
	[CCode (cheader_filename = "mirage/mirage.h")]
	public static string helper_find_data_file (string filename, string? path);
	[CCode (cheader_filename = "mirage/mirage.h")]
	public static string helper_format_stringd (string format, GLib.HashTable<void*,void*> dictionary);
	[CCode (cheader_filename = "mirage/mirage.h")]
	public static unowned string helper_get_suffix (string filename);
	[CCode (cheader_filename = "mirage/mirage.h")]
	public static bool helper_has_suffix (string filename, string suffix);
	[CCode (cheader_filename = "mirage/mirage.h")]
	public static int helper_hex2bcd (int hex);
	[CCode (cheader_filename = "mirage/mirage.h")]
	public static uint16 helper_init_crc16_lut (uint16 genpoly);
	[CCode (cheader_filename = "mirage/mirage.h")]
	public static uint32 helper_init_crc32_lut (uint32 genpoly, uint slices);
	[CCode (cheader_filename = "mirage/mirage.h")]
	public static uint8 helper_init_ecma_130b_scrambler_lut ();
	[CCode (cheader_filename = "mirage/mirage.h")]
	public static char helper_isrc2ascii (uint8 c);
	[CCode (cheader_filename = "mirage/mirage.h")]
	public static void helper_lba2msf (int lba, bool diff, out uint8 m, out uint8 s, out uint8 f);
	[CCode (cheader_filename = "mirage/mirage.h")]
	public static string helper_lba2msf_str (int lba, bool diff);
	[CCode (cheader_filename = "mirage/mirage.h")]
	public static int helper_msf2lba (uint8 m, uint8 s, uint8 f, bool diff);
	[CCode (cheader_filename = "mirage/mirage.h")]
	public static int helper_msf2lba_str (string msf, bool diff);
	[CCode (cheader_filename = "mirage/mirage.h")]
	public static void helper_sector_edc_ecc_compute_ecc_block (uint8 src, uint32 major_count, uint32 minor_count, uint32 major_mult, uint32 minor_inc, out uint8 dest);
	[CCode (cheader_filename = "mirage/mirage.h")]
	public static void helper_sector_edc_ecc_compute_edc_block ([CCode (array_length_cname = "size", array_length_pos = 1.5, array_length_type = "guint16")] uint8[] src, [CCode (array_length = false)] out unowned uint8 dest[4]);
	[CCode (cheader_filename = "mirage/mirage.h")]
	public static int helper_strcasecmp (string str1, string str2);
	[CCode (cheader_filename = "mirage/mirage.h")]
	public static int helper_strncasecmp (string str1, string str2, int len);
	[CCode (cheader_filename = "mirage/mirage.h")]
	public static void helper_subchannel_deinterleave (int subchan, [CCode (array_length = false)] uint8 channel96[96], [CCode (array_length = false)] out unowned uint8 channel12[12]);
	[CCode (cheader_filename = "mirage/mirage.h")]
	public static void helper_subchannel_interleave (int subchan, [CCode (array_length = false)] uint8 channel12[12], [CCode (array_length = false)] out unowned uint8 channel96[96]);
	[CCode (cheader_filename = "mirage/mirage.h")]
	public static uint16 helper_subchannel_q_calculate_crc ([CCode (array_length = false)] uint8 data[10]);
	[CCode (cheader_filename = "mirage/mirage.h")]
	public static void helper_subchannel_q_decode_isrc ([CCode (array_length = false)] uint8 buf[8], [CCode (array_length = false)] out unowned string isrc[12]);
	[CCode (cheader_filename = "mirage/mirage.h")]
	public static void helper_subchannel_q_decode_mcn ([CCode (array_length = false)] uint8 buf[7], [CCode (array_length = false)] out unowned string mcn[13]);
	[CCode (cheader_filename = "mirage/mirage.h")]
	public static void helper_subchannel_q_encode_isrc ([CCode (array_length = false)] out unowned uint8 buf[8], [CCode (array_length = false)] string isrc[12]);
	[CCode (cheader_filename = "mirage/mirage.h")]
	public static void helper_subchannel_q_encode_mcn ([CCode (array_length = false)] out unowned uint8 buf[7], [CCode (array_length = false)] string mcn[13]);
	[CCode (cheader_filename = "mirage/mirage.h")]
	public static bool helper_validate_isrc ([CCode (array_length = false)] string isrc[12]);
	[CCode (cheader_filename = "mirage/mirage.h")]
	public static bool initialize () throws GLib.Error;
	[CCode (cheader_filename = "mirage/mirage.h")]
	public static bool shutdown () throws GLib.Error;
}
