/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.classfmt;

import org.eclipse.jdt.internal.compiler.env.IBinaryAnnotation;
import org.eclipse.jdt.internal.compiler.env.IBinaryElementValuePair;
import org.eclipse.jdt.internal.compiler.env.IBinaryMethod;
import org.eclipse.jdt.internal.compiler.env.IBinaryTypeAnnotation;
import org.eclipse.jdt.internal.compiler.util.Util;

public class BinaryTypeFormatter {
    public static String annotationToString(IBinaryAnnotation iBinaryAnnotation) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('@');
        stringBuilder.append(iBinaryAnnotation.getTypeName());
        IBinaryElementValuePair[] iBinaryElementValuePairArray = iBinaryAnnotation.getElementValuePairs();
        if (iBinaryElementValuePairArray != null) {
            stringBuilder.append('(');
            stringBuilder.append("\n\t");
            int n = iBinaryElementValuePairArray.length;
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    stringBuilder.append(",\n\t");
                }
                stringBuilder.append(iBinaryElementValuePairArray[i]);
            }
            stringBuilder.append(')');
        }
        return stringBuilder.toString();
    }

    public static String annotationToString(IBinaryTypeAnnotation iBinaryTypeAnnotation) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(iBinaryTypeAnnotation.getAnnotation());
        stringBuilder.append(' ');
        stringBuilder.append("target_type=").append(iBinaryTypeAnnotation.getTargetType());
        stringBuilder.append(", info=").append(iBinaryTypeAnnotation.getSupertypeIndex());
        stringBuilder.append(", info2=").append(iBinaryTypeAnnotation.getBoundIndex());
        int[] nArray = iBinaryTypeAnnotation.getTypePath();
        if (nArray != null && nArray.length != 0) {
            stringBuilder.append(", location=[");
            int n = nArray.length;
            block6: for (int i = 0; i < n; i += 2) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                switch (nArray[i]) {
                    case 0: {
                        stringBuilder.append("ARRAY");
                        continue block6;
                    }
                    case 1: {
                        stringBuilder.append("INNER_TYPE");
                        continue block6;
                    }
                    case 2: {
                        stringBuilder.append("WILDCARD");
                        continue block6;
                    }
                    case 3: {
                        stringBuilder.append("TYPE_ARGUMENT(").append(nArray[i + 1]).append(')');
                    }
                }
            }
            stringBuilder.append(']');
        }
        return stringBuilder.toString();
    }

    public static String methodToString(IBinaryMethod iBinaryMethod) {
        StringBuffer stringBuffer = new StringBuffer();
        BinaryTypeFormatter.methodToStringContent(stringBuffer, iBinaryMethod);
        return stringBuffer.toString();
    }

    public static void methodToStringContent(StringBuffer stringBuffer, IBinaryMethod iBinaryMethod) {
        int n;
        int n2;
        Object[] objectArray;
        int n3 = iBinaryMethod.getModifiers();
        char[] cArray = iBinaryMethod.getGenericSignature();
        if (cArray == null) {
            cArray = iBinaryMethod.getMethodDescriptor();
        }
        stringBuffer.append('{').append(((n3 & 0x100000) != 0 ? "deprecated " : Util.EMPTY_STRING) + ((n3 & 1) == 1 ? "public " : Util.EMPTY_STRING) + ((n3 & 2) == 2 ? "private " : Util.EMPTY_STRING) + ((n3 & 4) == 4 ? "protected " : Util.EMPTY_STRING) + ((n3 & 8) == 8 ? "static " : Util.EMPTY_STRING) + ((n3 & 0x10) == 16 ? "final " : Util.EMPTY_STRING) + ((n3 & 0x40) == 64 ? "bridge " : Util.EMPTY_STRING) + ((n3 & 0x80) == 128 ? "varargs " : Util.EMPTY_STRING)).append(iBinaryMethod.getSelector()).append(cArray).append('}');
        Object object = iBinaryMethod.getDefaultValue();
        if (object != null) {
            stringBuffer.append(" default ");
            if (object instanceof Object[]) {
                stringBuffer.append('{');
                objectArray = (Object[])object;
                n2 = objectArray.length;
                for (n = 0; n < n2; ++n) {
                    if (n > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(objectArray[n]);
                }
                stringBuffer.append('}');
            } else {
                stringBuffer.append(object);
            }
            stringBuffer.append('\n');
        }
        objectArray = iBinaryMethod.getAnnotations();
        int n4 = n2 = objectArray == null ? 0 : objectArray.length;
        for (n = 0; n < n2; ++n) {
            stringBuffer.append(objectArray[n]);
            stringBuffer.append('\n');
        }
        n = iBinaryMethod.getAnnotatedParametersCount();
        for (n2 = 0; n2 < n; ++n2) {
            int n5;
            stringBuffer.append("param" + (n2 - 1));
            stringBuffer.append('\n');
            IBinaryAnnotation[] iBinaryAnnotationArray = iBinaryMethod.getParameterAnnotations(n2, new char[0]);
            int n6 = n5 = iBinaryAnnotationArray == null ? 0 : iBinaryAnnotationArray.length;
            for (int i = 0; i < n5; ++i) {
                stringBuffer.append(iBinaryAnnotationArray[i]);
                stringBuffer.append('\n');
            }
        }
    }
}

