/*
 * Decompiled with CFR 0.152.
 */
package processing.app.debug;

import processing.app.SketchFile;

public class RunnerException
extends Exception {
    protected String message;
    protected SketchFile codeFile;
    protected int codeLine;
    protected int codeColumn;
    protected boolean showStackTrace;

    public RunnerException(String message) {
        this(message, true);
    }

    public RunnerException(String message, boolean showStackTrace) {
        this(message, null, -1, -1, showStackTrace);
    }

    public RunnerException(String message, SketchFile file, int line) {
        this(message, file, line, -1, true);
    }

    public RunnerException(String message, SketchFile file, int line, int column) {
        this(message, file, line, column, true);
    }

    public RunnerException(String message, SketchFile file, int line, int column, boolean showStackTrace) {
        this.message = message;
        this.codeFile = file;
        this.codeLine = line;
        this.codeColumn = column;
        this.showStackTrace = showStackTrace;
    }

    public RunnerException(Exception e) {
        super(e);
        this.showStackTrace = true;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public SketchFile getCodeFile() {
        return this.codeFile;
    }

    public void setCodeFile(SketchFile file) {
        this.codeFile = file;
    }

    public boolean hasCodeFile() {
        return this.codeFile != null;
    }

    public int getCodeLine() {
        return this.codeLine;
    }

    public void setCodeLine(int line) {
        this.codeLine = line;
    }

    public boolean hasCodeLine() {
        return this.codeLine != -1;
    }

    public void setCodeColumn(int column) {
        this.codeColumn = column;
    }

    public int getCodeColumn() {
        return this.codeColumn;
    }

    public void showStackTrace() {
        this.showStackTrace = true;
    }

    public void hideStackTrace() {
        this.showStackTrace = false;
    }

    @Override
    public void printStackTrace() {
        if (this.showStackTrace) {
            super.printStackTrace();
        }
    }
}

