<?php

use Rumenx\PhpChatbot\Support\CurlHttpClient;
use Rumenx\PhpChatbot\Support\HttpClientInterface;

test('CurlHttpClient implements HttpClientInterface', function () {
    $client = new CurlHttpClient();
    expect($client)->toBeInstanceOf(HttpClientInterface::class);
});

test('CurlHttpClient can be instantiated', function () {
    $client = new CurlHttpClient();
    expect($client)->toBeInstanceOf(CurlHttpClient::class);
});

test('CurlHttpClient throws RuntimeException on invalid URL', function () {
    $client = new CurlHttpClient();
    
    $client->post(
        'invalid-url-without-protocol',
        ['Content-Type' => 'application/json'],
        '{"test": "data"}'
    );
})->throws(\RuntimeException::class, 'cURL request failed');

test('CurlHttpClient throws RuntimeException on unreachable host', function () {
    $client = new CurlHttpClient();
    
    $client->post(
        'http://localhost:99999/invalid',
        ['Content-Type' => 'application/json'],
        '{"test": "data"}'
    );
})->throws(\RuntimeException::class);

test('CurlHttpClient handles streaming callback invocation', function () {
    $client = new CurlHttpClient();
    $callbackInvoked = false;
    
    $streamCallback = function ($ch, $chunk) use (&$callbackInvoked) {
        $callbackInvoked = true;
        return strlen($chunk);
    };
    
    try {
        // This will fail but should invoke the callback before failing
        $client->post(
            'http://localhost:99999/test',
            ['Content-Type' => 'application/json'],
            '{"test": "data"}',
            $streamCallback
        );
    } catch (\RuntimeException $e) {
        // Expected to fail, but we're testing structure
        expect($e->getMessage())->toContain('cURL request failed');
    }
});

test('CurlHttpClient returns empty string when using streaming callback', function () {
    // We can't easily test a successful streaming request without a real server,
    // but we can document the expected behavior that when a callback is provided,
    // the return value should be an empty string (as the data goes through the callback)
    // This is tested indirectly through MockHttpClient in other tests
    expect(true)->toBeTrue();
});

test('CurlHttpClient converts headers correctly', function () {
    // Test that headers are properly formatted
    $client = new CurlHttpClient();
    
    // This will fail (unreachable host) but will test header conversion
    try {
        $client->post(
            'http://localhost:99999/test',
            [
                'Content-Type' => 'application/json',
                'Authorization' => 'Bearer test-token',
                'X-Custom-Header' => 'custom-value'
            ],
            '{"test": "data"}'
        );
    } catch (\RuntimeException $e) {
        // Expected - we're just testing that the method processes headers without error
        expect($e)->toBeInstanceOf(\RuntimeException::class);
    }
});
